/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.internal.pb;
import com.google.android.gms.internal.pm;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.PutDataRequest;

public class PutDataMapRequest {
    private final PutDataRequest auN;
    private final DataMap auM;

    private PutDataMapRequest(PutDataRequest putDataRequest, DataMap dataMap) {
        this.auN = putDataRequest;
        this.auM = new DataMap();
        if (dataMap != null) {
            this.auM.putAll(dataMap);
        }
    }

    public static PutDataMapRequest createFromDataMapItem(DataMapItem source) {
        return new PutDataMapRequest(PutDataRequest.k(source.getUri()), source.getDataMap());
    }

    public static PutDataMapRequest createWithAutoAppendedId(String pathPrefix) {
        return new PutDataMapRequest(PutDataRequest.createWithAutoAppendedId(pathPrefix), null);
    }

    public static PutDataMapRequest create(String path) {
        return new PutDataMapRequest(PutDataRequest.create(path), null);
    }

    public Uri getUri() {
        return this.auN.getUri();
    }

    public DataMap getDataMap() {
        return this.auM;
    }

    public PutDataRequest asPutDataRequest() {
        pb.a a2 = pb.a(this.auM);
        this.auN.setData(pm.f(a2.avQ));
        int n2 = a2.avR.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = Integer.toString(i2);
            Asset asset = a2.avR.get(i2);
            if (string == null) {
                throw new IllegalStateException("asset key cannot be null: " + asset);
            }
            if (asset == null) {
                throw new IllegalStateException("asset cannot be null: key=" + string);
            }
            if (Log.isLoggable((String)"DataMap", (int)3)) {
                Log.d((String)"DataMap", (String)("asPutDataRequest: adding asset: " + string + " " + asset));
            }
            this.auN.putAsset(string, asset);
        }
        return this.auN;
    }
}

