/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.dynamic.h;
import com.google.android.gms.internal.oq;
import com.google.android.gms.internal.or;
import com.google.android.gms.internal.oy;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private b atF;
    private boolean mCreated = false;
    private final h atG = h.a(this);
    private final c atH = new c();
    private a atI = new a(this);
    private final Fragment Ll = this;
    private WalletFragmentOptions atJ;
    private WalletFragmentInitParams atK;
    private MaskedWalletRequest atL;
    private MaskedWallet atM;
    private Boolean atN;

    public static SupportWalletFragment newInstance(WalletFragmentOptions options) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        supportWalletFragment.Ll.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.atF != null) {
            this.atF.initialize(initParams);
            this.atK = null;
        } else if (this.atK == null) {
            this.atK = initParams;
            if (this.atL != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.atM != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.atF != null) {
            this.atF.updateMaskedWalletRequest(request);
            this.atL = null;
        } else {
            this.atL = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.atF != null) {
            this.atF.updateMaskedWallet(maskedWallet);
            this.atM = null;
        } else {
            this.atM = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.atF != null) {
            this.atF.setEnabled(enabled);
            this.atN = null;
        } else {
            this.atN = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.atI.a(listener);
    }

    public int getState() {
        return this.atF != null ? this.atF.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.atJ == null) {
            this.atJ = WalletFragmentOptions.a((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.atJ);
        this.atH.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.atK != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.atK = walletFragmentInitParams;
            }
            if (this.atL == null) {
                this.atL = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.atM == null) {
                this.atM = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.atJ = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.atN = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.Ll.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.Ll.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.Z((Context)this.Ll.getActivity());
            this.atJ = walletFragmentOptions;
        }
        this.mCreated = true;
        this.atH.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.atH.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.atH.onStart();
    }

    public void onResume() {
        super.onResume();
        this.atH.onResume();
        FragmentManager fragmentManager = this.Ll.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.Ll.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment(n2, (Activity)this.Ll.getActivity(), -1);
        }
    }

    public void onPause() {
        super.onPause();
        this.atH.onPause();
    }

    public void onStop() {
        super.onStop();
        this.atH.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.atH.onSaveInstanceState(outState);
        if (this.atK != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.atK);
            this.atK = null;
        }
        if (this.atL != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.atL);
            this.atL = null;
        }
        if (this.atM != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.atM);
            this.atM = null;
        }
        if (this.atJ != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.atJ);
            this.atJ = null;
        }
        if (this.atN != null) {
            outState.putBoolean("enabled", this.atN.booleanValue());
            this.atN = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.atF != null) {
            this.atF.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class a
    extends or.a {
        private OnStateChangedListener atO;
        private final SupportWalletFragment atP;

        a(SupportWalletFragment supportWalletFragment) {
            this.atP = supportWalletFragment;
        }

        @Override
        public void a(int n2, int n3, Bundle bundle) {
            if (this.atO != null) {
                this.atO.onStateChanged(this.atP, n2, n3, bundle);
            }
        }

        public void a(OnStateChangedListener onStateChangedListener) {
            this.atO = onStateChangedListener;
        }
    }

    private static class b
    implements LifecycleDelegate {
        private final oq atQ;

        private b(oq oq2) {
            this.atQ = oq2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.atQ.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.atQ.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.atQ.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.atQ.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.atQ.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.atQ.a(e.k(activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.atQ.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                d d2 = this.atQ.onCreateView(e.k(inflater), e.k(container), savedInstanceState);
                return (View)e.f(d2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStart() {
            try {
                this.atQ.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onResume() {
            try {
                this.atQ.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.atQ.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStop() {
            try {
                this.atQ.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onDestroyView() {
        }

        @Override
        public void onDestroy() {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.atQ.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.atQ.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class c
    extends com.google.android.gms.dynamic.a<b>
    implements View.OnClickListener {
        private c() {
        }

        @Override
        protected void a(f<b> f2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Ll.getActivity();
            if (SupportWalletFragment.this.atF == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    oq oq2 = oy.a((Activity)fragmentActivity, SupportWalletFragment.this.atG, SupportWalletFragment.this.atJ, SupportWalletFragment.this.atI);
                    SupportWalletFragment.this.atF = new b(oq2);
                    SupportWalletFragment.this.atJ = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                f2.a(SupportWalletFragment.this.atF);
                if (SupportWalletFragment.this.atK != null) {
                    SupportWalletFragment.this.atF.initialize(SupportWalletFragment.this.atK);
                    SupportWalletFragment.this.atK = null;
                }
                if (SupportWalletFragment.this.atL != null) {
                    SupportWalletFragment.this.atF.updateMaskedWalletRequest(SupportWalletFragment.this.atL);
                    SupportWalletFragment.this.atL = null;
                }
                if (SupportWalletFragment.this.atM != null) {
                    SupportWalletFragment.this.atF.updateMaskedWallet(SupportWalletFragment.this.atM);
                    SupportWalletFragment.this.atM = null;
                }
                if (SupportWalletFragment.this.atN != null) {
                    SupportWalletFragment.this.atF.setEnabled(SupportWalletFragment.this.atN);
                    SupportWalletFragment.this.atN = null;
                }
            }
        }

        @Override
        protected void a(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.Ll.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n2 = -1;
            int n3 = -2;
            if (SupportWalletFragment.this.atJ != null && (walletFragmentStyle = SupportWalletFragment.this.atJ.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.Ll.getResources().getDisplayMetrics();
                n2 = walletFragmentStyle.a("buyButtonWidth", displayMetrics, n2);
                n3 = walletFragmentStyle.a("buyButtonHeight", displayMetrics, n3);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n2, n3));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.Ll.getActivity();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment(n2, (Activity)fragmentActivity, -1);
        }
    }
}

