/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.c;
import com.google.android.gms.internal.ok;
import com.google.android.gms.internal.pl;
import com.google.android.gms.internal.pm;
import com.google.android.gms.tagmanager.ba;
import com.google.android.gms.tagmanager.bg;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class cq
implements o.f {
    private final Context mContext;
    private final String anR;
    private final ExecutorService aqp;
    private bg<ok.a> aqi;

    cq(Context context, String string) {
        this.mContext = context;
        this.anR = string;
        this.aqp = Executors.newSingleThreadExecutor();
    }

    @Override
    public void a(bg<ok.a> bg2) {
        this.aqi = bg2;
    }

    @Override
    public void oa() {
        this.aqp.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.oP();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void oP() {
        if (this.aqi == null) {
            throw new IllegalStateException("Callback must be set before execute");
        }
        this.aqi.nZ();
        bh.V("Attempting to load resource from disk");
        if ((ce.oH().oI() == ce.a.apX || ce.oH().oI() == ce.a.apY) && this.anR.equals(ce.oH().getContainerId())) {
            this.aqi.a(bg.a.apB);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.oQ());
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.S("Failed to find the resource in the disk");
            this.aqi.a(bg.a.apB);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(fileInputStream, byteArrayOutputStream);
            ok.a a2 = ok.a.l(byteArrayOutputStream.toByteArray());
            this.d(a2);
            this.aqi.l(a2);
        }
        catch (IOException iOException) {
            this.aqi.a(bg.a.apC);
            bh.W("Failed to read the resource from disk");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.aqi.a(bg.a.apC);
            bh.W("Failed to read the resource from disk. The resource is inconsistent");
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bh.W("Error closing stream for reading resource from disk");
            }
        }
        bh.V("The Disk resource was successfully read.");
    }

    @Override
    public void b(final ok.a a2) {
        this.aqp.execute(new Runnable(){

            @Override
            public void run() {
                cq.this.c(a2);
            }
        });
    }

    @Override
    public cr.c fe(int n2) {
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n2);
        }
        catch (Resources.NotFoundException notFoundException) {
            bh.W("Failed to load the container. No default container resource found with the resource ID " + n2);
            return null;
        }
        bh.V("Attempting to load a container from the resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cr.b(inputStream, byteArrayOutputStream);
            cr.c c2 = this.a(byteArrayOutputStream);
            if (c2 != null) {
                bh.V("The container was successfully loaded from the resource (using JSON file format)");
                return c2;
            }
            return this.k(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            bh.W("Error reading the default container with resource ID " + n2 + " (" + this.mContext.getResources().getResourceName(n2) + ")");
            return null;
        }
    }

    private cr.c a(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = byteArrayOutputStream.toString("UTF-8");
            return ba.cD(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bh.S("Failed to convert binary resource to string for JSON parsing; the file format is not UTF-8 format.");
            return null;
        }
        catch (JSONException jSONException) {
            bh.W("Failed to extract the container from the resource file. Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private cr.c k(byte[] byArray) {
        try {
            cr.c c2 = cr.b(c.f.a(byArray));
            if (c2 != null) {
                bh.V("The container was successfully loaded from the resource (using binary file)");
            }
            return c2;
        }
        catch (pl pl2) {
            bh.T("The resource file is corrupted. The container cannot be extracted from the binary file");
            return null;
        }
        catch (cr.g g2) {
            bh.W("The resource file is invalid. The container from the binary file is invalid");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.aqp.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(ok.a a2) {
        FileOutputStream fileOutputStream = null;
        File file = this.oQ();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.T("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(pm.f(a2));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            bh.W("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                bh.W("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File oQ() {
        String string = "resource_" + this.anR;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string);
    }

    private void d(ok.a a2) throws IllegalArgumentException {
        if (a2.gs == null && a2.ash == null) {
            throw new IllegalArgumentException("Resource and SupplementedResource are NULL.");
        }
    }
}

