/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.internal.ju;
import com.google.android.gms.internal.jw;
import com.google.android.gms.tagmanager.ab;
import com.google.android.gms.tagmanager.ak;
import com.google.android.gms.tagmanager.ap;
import com.google.android.gms.tagmanager.at;
import com.google.android.gms.tagmanager.au;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.cy;
import com.google.android.gms.tagmanager.db;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class cb
implements at {
    private static final String AY = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL,'%s' INTEGER NOT NULL);", "gtm_hits", "hit_id", "hit_time", "hit_url", "hit_first_send_time");
    private final b apL;
    private volatile ab apM;
    private final au apN;
    private final Context mContext;
    private final String Bb;
    private long Bd;
    private ju yD;
    private final int Be;

    cb(au au2, Context context) {
        this(au2, context, "gtm_urls.db", 2000);
    }

    cb(au au2, Context context, String string, int n2) {
        this.mContext = context.getApplicationContext();
        this.Bb = string;
        this.apN = au2;
        this.yD = jw.hA();
        this.apL = new b(this.mContext, this.Bb);
        this.apM = new db((HttpClient)new DefaultHttpClient(), this.mContext, new a());
        this.Bd = 0L;
        this.Be = n2;
    }

    @Override
    public void f(long l2, String string) {
        this.eO();
        this.eN();
        this.g(l2, string);
    }

    private void eN() {
        int n2 = this.eP() - this.Be + 1;
        if (n2 > 0) {
            List<String> list = this.F(n2);
            bh.V("Store full, deleting " + list.size() + " hits to make room.");
            this.b(list.toArray(new String[0]));
        }
    }

    private void g(long l2, String string) {
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_time", Long.valueOf(l2));
        contentValues.put("hit_url", string);
        contentValues.put("hit_first_send_time", Integer.valueOf(0));
        try {
            sQLiteDatabase.insert("gtm_hits", null, contentValues);
            this.apN.z(false);
        }
        catch (SQLiteException sQLiteException) {
            bh.W("Error storing hit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> F(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            bh.W("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ap> G(int n2) {
        ArrayList<ap> arrayList = new ArrayList<ap>();
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_time", "hit_first_send_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    ap ap2 = new ap(cursor.getLong(0), cursor.getLong(1), cursor.getLong(2));
                    arrayList.add(ap2);
                } while (cursor.moveToNext());
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((ap)arrayList.get(n3)).ak(cursor.getString(1));
                    } else {
                        bh.W(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((ap)arrayList.get(n3)).eH()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            bh.W("Error in peekHits fetching hit url: " + sQLiteException.getMessage());
            ArrayList<ap> arrayList2 = new ArrayList<ap>();
            boolean bl2 = false;
            for (ap ap3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)ap3.os())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList2.add(ap3);
            }
            ArrayList<ap> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int eO() {
        long l2 = this.yD.currentTimeMillis();
        if (l2 <= this.Bd + 86400000L) {
            return 0;
        }
        this.Bd = l2;
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.yD.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("gtm_hits", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.apN.z(this.eP() == 0);
        return n2;
    }

    void b(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("gtm_hits", string, stringArray);
            this.apN.z(this.eP() == 0);
        }
        catch (SQLiteException sQLiteException) {
            bh.W("Error deleting hits");
        }
    }

    private void y(long l2) {
        this.b(new String[]{String.valueOf(l2)});
    }

    private void c(long l2, long l3) {
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_first_send_time", Long.valueOf(l3));
        try {
            sQLiteDatabase.update("gtm_hits", contentValues, "hit_id=?", new String[]{String.valueOf(l2)});
        }
        catch (SQLiteException sQLiteException) {
            bh.W("Error setting HIT_FIRST_DISPATCH_TIME for hitId: " + l2);
            this.y(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int eP() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from gtm_hits", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int oF() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.al("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("gtm_hits", new String[]{"hit_id", "hit_first_send_time"}, "hit_first_send_time=0", null, null, null, null);
            n2 = cursor.getCount();
        }
        return n2;
    }

    @Override
    public void dispatch() {
        bh.V("GTM Dispatch running...");
        if (!this.apM.dY()) {
            return;
        }
        List<ap> list = this.G(40);
        if (list.isEmpty()) {
            bh.V("...nothing to dispatch");
            this.apN.z(true);
            return;
        }
        this.apM.j(list);
        if (this.oF() > 0) {
            cy.pu().dispatch();
        }
    }

    private SQLiteDatabase al(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.apL.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            bh.W(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class b
    extends SQLiteOpenHelper {
        private boolean Bf;
        private long Bg;

        b(Context context, String string) {
            super(context, string, null, 1);
            this.Bg = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.Bf && this.Bg + 3600000L > cb.this.yD.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.Bf = true;
            this.Bg = cb.this.yD.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                cb.this.mContext.getDatabasePath(cb.this.Bb).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.Bf = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.a("gtm_hits", db2)) {
                db2.execSQL(AY);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM gtm_hits WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_time") && hashSet.remove("hit_first_send_time"))) {
                throw new SQLiteException("Database column missing");
            }
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            ak.ag(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }

    class a
    implements db.a {
        a() {
        }

        @Override
        public void a(ap ap2) {
            cb.this.y(ap2.eH());
        }

        @Override
        public void b(ap ap2) {
            cb.this.y(ap2.eH());
            bh.V("Permanent failure dispatching hitId: " + ap2.eH());
        }

        @Override
        public void c(ap ap2) {
            long l2 = ap2.or();
            if (l2 == 0L) {
                cb.this.c(ap2.eH(), cb.this.yD.currentTimeMillis());
            } else if (l2 + 14400000L < cb.this.yD.currentTimeMillis()) {
                cb.this.y(ap2.eH());
                bh.V("Giving up on failed hitId: " + ap2.eH());
            }
        }
    }
}

