/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.c;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.ag;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.br;
import com.google.android.gms.tagmanager.ce;
import com.google.android.gms.tagmanager.cr;
import com.google.android.gms.tagmanager.ct;
import com.google.android.gms.tagmanager.di;
import com.google.android.gms.tagmanager.s;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String anR;
    private final DataLayer anS;
    private ct anT;
    private Map<String, FunctionCallMacroCallback> anU = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> anV = new HashMap<String, FunctionCallTagCallback>();
    private volatile long anW;
    private volatile String anX = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, cr.c resource) {
        this.mContext = context;
        this.anS = dataLayer;
        this.anR = containerId;
        this.anW = lastRefreshTime;
        this.a(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, c.j resource) {
        this.mContext = context;
        this.anS = dataLayer;
        this.anR = containerId;
        this.anW = lastRefreshTime;
        this.a(resource.gs);
        if (resource.gr != null) {
            this.a(resource.gr);
        }
    }

    public String getContainerId() {
        return this.anR;
    }

    public boolean getBoolean(String key) {
        ct ct2 = this.nR();
        if (ct2 == null) {
            bh.T("getBoolean called for closed container.");
            return di.pF();
        }
        try {
            return di.n(ct2.cO(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.pF();
        }
    }

    public double getDouble(String key) {
        ct ct2 = this.nR();
        if (ct2 == null) {
            bh.T("getDouble called for closed container.");
            return di.pE();
        }
        try {
            return di.m(ct2.cO(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.pE();
        }
    }

    public long getLong(String key) {
        ct ct2 = this.nR();
        if (ct2 == null) {
            bh.T("getLong called for closed container.");
            return di.pD();
        }
        try {
            return di.l(ct2.cO(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.pD();
        }
    }

    public String getString(String key) {
        ct ct2 = this.nR();
        if (ct2 == null) {
            bh.T("getString called for closed container.");
            return di.pH();
        }
        try {
            return di.j(ct2.cO(key).getObject());
        }
        catch (Exception exception) {
            bh.T("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return di.pH();
        }
    }

    public long getLastRefreshTime() {
        return this.anW;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.anU;
        synchronized (map) {
            this.anU.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.anU;
        synchronized (map) {
            this.anU.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback ck(String string) {
        Map<String, FunctionCallMacroCallback> map = this.anU;
        synchronized (map) {
            return this.anU.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.anV;
        synchronized (map) {
            this.anV.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.anV;
        synchronized (map) {
            this.anV.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback cl(String string) {
        Map<String, FunctionCallTagCallback> map = this.anV;
        synchronized (map) {
            return this.anV.get(string);
        }
    }

    void cm(String string) {
        this.nR().cm(string);
    }

    String nQ() {
        return this.anX;
    }

    private void a(c.f f2) {
        if (f2 == null) {
            throw new NullPointerException();
        }
        cr.c c2 = null;
        try {
            c2 = cr.b(f2);
        }
        catch (cr.g g2) {
            bh.T("Not loading resource: " + f2 + " because it is invalid: " + g2.toString());
            return;
        }
        this.a(c2);
    }

    private void a(c.i[] iArray) {
        ArrayList<c.i> arrayList = new ArrayList<c.i>();
        for (c.i i2 : iArray) {
            arrayList.add(i2);
        }
        this.nR().k(arrayList);
    }

    private void a(cr.c c2) {
        this.anX = c2.getVersion();
        ag ag2 = this.cn(this.anX);
        ct ct2 = new ct(this.mContext, c2, this.anS, new a(), new b(), ag2);
        this.a(ct2);
    }

    ag cn(String string) {
        if (ce.oH().oI().equals((Object)ce.a.apY)) {
            // empty if block
        }
        return new br();
    }

    private synchronized void a(ct ct2) {
        this.anT = ct2;
    }

    private synchronized ct nR() {
        return this.anT;
    }

    void release() {
        this.anT = null;
    }

    private class b
    implements s.a {
        private b() {
        }

        @Override
        public Object b(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.cl(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return di.pH();
        }
    }

    private class a
    implements s.a {
        private a() {
        }

        @Override
        public Object b(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.ck(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

