/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.q;
import com.google.android.gms.plus.internal.g;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View ala;
    private int mSize;
    private int alb;
    private String uR;
    private int alc;
    private OnPlusOneClickListener ald;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.alb = PlusOneButton.getAnnotation(context, attrs);
        this.alc = -1;
        this.G(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attrs) {
        String string2 = q.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "size", context, attrs, true, false, "PlusOneButton");
        return "SMALL".equalsIgnoreCase(string2) ? 0 : ("MEDIUM".equalsIgnoreCase(string2) ? 1 : ("TALL".equalsIgnoreCase(string2) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attrs) {
        String string2 = q.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "annotation", context, attrs, true, false, "PlusOneButton");
        return "INLINE".equalsIgnoreCase(string2) ? 2 : ("NONE".equalsIgnoreCase(string2) ? 0 : 1);
    }

    private void G(Context context) {
        if (this.ala != null) {
            this.removeView(this.ala);
        }
        this.ala = g.a(context, this.mSize, this.alb, this.uR, this.alc);
        this.setOnPlusOneClickListener(this.ald);
        this.addView(this.ala);
    }

    public void initialize(String url, int activityRequestCode) {
        n.a(this.getContext() instanceof Activity, "To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.uR = url;
        this.alc = activityRequestCode;
        this.G(this.getContext());
    }

    public void initialize(String url, OnPlusOneClickListener plusOneClickListener) {
        this.uR = url;
        this.alc = 0;
        this.G(this.getContext());
        this.setOnPlusOneClickListener(plusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener listener) {
        this.ald = listener;
        this.ala.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(listener));
    }

    public void setAnnotation(int annotation) {
        this.alb = annotation;
        this.G(this.getContext());
    }

    public void setSize(int size) {
        this.mSize = size;
        this.G(this.getContext());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View view = this.ala;
        this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.ala.layout(0, 0, right - left, bottom - top);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener ale;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener proxy) {
            this.ale = proxy;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.ala.getTag();
            if (this.ale != null) {
                this.ale.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.alc);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

