/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.e;
import com.google.android.gms.maps.model.f;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final e CREATOR = new e();
    public static final float NO_DIMENSION = -1.0f;
    private final int BR;
    private BitmapDescriptor ajD;
    private LatLng ajE;
    private float ajF;
    private float ajG;
    private LatLngBounds ajH;
    private float ajt;
    private float ajA;
    private boolean ajB = true;
    private float ajI = 0.0f;
    private float ajJ = 0.5f;
    private float ajK = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.BR = versionCode;
        this.ajD = new BitmapDescriptor(d.a.am(wrappedImage));
        this.ajE = location;
        this.ajF = width;
        this.ajG = height;
        this.ajH = bounds;
        this.ajt = bearing;
        this.ajA = zIndex;
        this.ajB = visible;
        this.ajI = transparency;
        this.ajJ = anchorU;
        this.ajK = anchorV;
    }

    public GroundOverlayOptions() {
        this.BR = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.mK()) {
            f.a(this, out, flags);
        } else {
            e.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder mM() {
        return this.ajD.mm().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.ajD = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.ajJ = u2;
        this.ajK = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        n.a(this.ajH == null, "Position has already been set using positionFromBounds");
        n.b(location != null, (Object)"Location must be specified");
        n.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        n.a(this.ajH == null, "Position has already been set using positionFromBounds");
        n.b(location != null, (Object)"Location must be specified");
        n.b(width >= 0.0f, (Object)"Width must be non-negative");
        n.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.ajE = latLng;
        this.ajF = f2;
        this.ajG = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        n.a(this.ajE == null, "Position has already been set using position: " + this.ajE);
        this.ajH = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.ajt = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.ajA = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.ajB = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        n.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.ajI = transparency;
        return this;
    }

    int getVersionCode() {
        return this.BR;
    }

    public BitmapDescriptor getImage() {
        return this.ajD;
    }

    public LatLng getLocation() {
        return this.ajE;
    }

    public float getWidth() {
        return this.ajF;
    }

    public float getHeight() {
        return this.ajG;
    }

    public LatLngBounds getBounds() {
        return this.ajH;
    }

    public float getBearing() {
        return this.ajt;
    }

    public float getZIndex() {
        return this.ajA;
    }

    public float getTransparency() {
        return this.ajI;
    }

    public float getAnchorU() {
        return this.ajJ;
    }

    public float getAnchorV() {
        return this.ajK;
    }

    public boolean isVisible() {
        return this.ajB;
    }
}

