/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.b;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final a CREATOR = new a();
    private final int BR;
    private Boolean aiv;
    private Boolean aiw;
    private int aix = -1;
    private CameraPosition aiy;
    private Boolean aiz;
    private Boolean aiA;
    private Boolean aiB;
    private Boolean aiC;
    private Boolean aiD;
    private Boolean aiE;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.BR = versionCode;
        this.aiv = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.aiw = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.aix = mapType;
        this.aiy = camera;
        this.aiz = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.aiA = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.aiB = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.aiC = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.aiD = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.aiE = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.mK()) {
            b.a(this, out, flags);
        } else {
            a.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.BR;
    }

    byte mp() {
        return com.google.android.gms.maps.internal.a.c(this.aiv);
    }

    byte mq() {
        return com.google.android.gms.maps.internal.a.c(this.aiw);
    }

    byte mr() {
        return com.google.android.gms.maps.internal.a.c(this.aiz);
    }

    byte ms() {
        return com.google.android.gms.maps.internal.a.c(this.aiA);
    }

    byte mt() {
        return com.google.android.gms.maps.internal.a.c(this.aiB);
    }

    byte mu() {
        return com.google.android.gms.maps.internal.a.c(this.aiC);
    }

    byte mv() {
        return com.google.android.gms.maps.internal.a.c(this.aiD);
    }

    byte mw() {
        return com.google.android.gms.maps.internal.a.c(this.aiE);
    }

    public GoogleMapOptions() {
        this.BR = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.aiv = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.aiw = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.aix = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.aiy = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.aiz = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.aiA = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.aiB = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.aiC = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.aiD = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.aiE = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.aiv;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.aiw;
    }

    public int getMapType() {
        return this.aix;
    }

    public CameraPosition getCamera() {
        return this.aiy;
    }

    public Boolean getZoomControlsEnabled() {
        return this.aiz;
    }

    public Boolean getCompassEnabled() {
        return this.aiA;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.aiB;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.aiC;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.aiD;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.aiE;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(R.styleable.MapAttrs_mapType)) {
            googleMapOptions.mapType(typedArray.getInt(R.styleable.MapAttrs_mapType, -1));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_zOrderOnTop)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(R.styleable.MapAttrs_zOrderOnTop, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_useViewLifecycle)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(R.styleable.MapAttrs_useViewLifecycle, false));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiCompass)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiCompass, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiRotateGestures)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiRotateGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiScrollGestures)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiScrollGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiTiltGestures)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiTiltGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomGestures)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomGestures, true));
        }
        if (typedArray.hasValue(R.styleable.MapAttrs_uiZoomControls)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(R.styleable.MapAttrs_uiZoomControls, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

