/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.b;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int BR;
    int mPriority;
    long aeh;
    long aei;
    boolean Uz;
    long adX;
    int aej;
    float aek;
    long ael;
    public static final b CREATOR = new b();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.BR = 1;
        this.mPriority = 102;
        this.aeh = 3600000L;
        this.aei = 600000L;
        this.Uz = false;
        this.adX = Long.MAX_VALUE;
        this.aej = Integer.MAX_VALUE;
        this.aek = 0.0f;
        this.ael = 0L;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.ea(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.v(millis);
        this.aeh = millis;
        if (!this.Uz) {
            this.aei = (long)((double)this.aeh / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.aeh;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.v(millis);
        this.Uz = true;
        this.aei = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.aei;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.adX = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.adX < 0L) {
            this.adX = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.adX = millis;
        if (this.adX < 0L) {
            this.adX = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.adX;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.aej = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.aej;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.aek = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.aek;
    }

    private static void v(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void ea(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement, long maxWaitTime) {
        this.BR = versionCode;
        this.mPriority = priority;
        this.aeh = interval;
        this.aei = fastestInterval;
        this.Uz = explicitFastestInterval;
        this.adX = expireAt;
        this.aej = numUpdates;
        this.aek = smallestDisplacement;
        this.ael = maxWaitTime;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        b.a(this, parcel, flags);
    }

    public static String eb(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.eb(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.aeh + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.aei + "ms");
        if (this.adX != Long.MAX_VALUE) {
            long l2 = this.adX - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.aej != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.aej);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return m.hashCode(this.mPriority, this.aeh, this.aei, this.Uz, this.adX, this.aej, Float.valueOf(this.aek));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.aeh == locationRequest.aeh && this.aei == locationRequest.aei && this.Uz == locationRequest.Uz && this.adX == locationRequest.adX && this.aej == locationRequest.aej && this.aek == locationRequest.aek;
    }

    int getVersionCode() {
        return this.BR;
    }
}

