/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.text.TextUtils;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.ip;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class iu {
    private static final ip Gr = new ip("MetadataUtils");
    private static final String[] HA = new String[]{"Z", "+hh", "+hhmm", "+hh:mm"};
    private static final String HB = "yyyyMMdd'T'HHmmss" + HA[0];

    public static void a(List<WebImage> list, JSONObject jSONObject) {
        try {
            list.clear();
            JSONArray jSONArray = jSONObject.getJSONArray("images");
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                try {
                    list.add(new WebImage(jSONObject2));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void a(JSONObject jSONObject, List<WebImage> list) {
        if (list != null && !list.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (WebImage webImage : list) {
                jSONArray.put((Object)webImage.bL());
            }
            try {
                jSONObject.put("images", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public static String a(Calendar calendar) {
        if (calendar == null) {
            Gr.b("Calendar object cannot be null", new Object[0]);
            return null;
        }
        String string = HB;
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            string = "yyyyMMdd";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(calendar.getTimeZone());
        String string2 = simpleDateFormat.format(calendar.getTime());
        if (string2.endsWith("+0000")) {
            string2 = string2.replace("+0000", HA[0]);
        }
        return string2;
    }

    public static Calendar aL(String string) {
        Date date;
        if (TextUtils.isEmpty((CharSequence)string)) {
            Gr.b("Input string is empty or null", new Object[0]);
            return null;
        }
        String string2 = iu.aM(string);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Gr.b("Invalid date format", new Object[0]);
            return null;
        }
        String string3 = iu.aN(string);
        String string4 = "yyyyMMdd";
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string2 = string2 + "T" + string3;
            string4 = string3.length() == "HHmmss".length() ? "yyyyMMdd'T'HHmmss" : HB;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        try {
            date = new SimpleDateFormat(string4).parse(string2);
        }
        catch (ParseException parseException) {
            Gr.b("Error parsing string: %s", parseException.getMessage());
            return null;
        }
        calendar.setTime(date);
        return calendar;
    }

    private static String aM(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Gr.b("Input string is empty or null", new Object[0]);
            return null;
        }
        try {
            return string.substring(0, "yyyyMMdd".length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Gr.c("Error extracting the date: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
    }

    private static String aN(String string) {
        String string2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            Gr.b("string is empty or null", new Object[0]);
            return null;
        }
        int n2 = string.indexOf(84);
        if (n2++ != "yyyyMMdd".length()) {
            Gr.b("T delimeter is not found", new Object[0]);
            return null;
        }
        try {
            string2 = string.substring(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Gr.b("Error extracting the time substring: %s", indexOutOfBoundsException.getMessage());
            return null;
        }
        if (string2.length() == "HHmmss".length()) {
            return string2;
        }
        char c2 = string2.charAt("HHmmss".length());
        switch (c2) {
            case 'Z': {
                if (string2.length() == "HHmmss".length() + HA[0].length()) {
                    return string2.substring(0, string2.length() - 1) + "+0000";
                }
                return null;
            }
            case '+': 
            case '-': {
                if (!iu.aO(string2)) break;
                return string2.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
            }
        }
        return null;
    }

    private static boolean aO(String string) {
        int n2;
        int n3 = string.length();
        return n3 == (n2 = "HHmmss".length()) + HA[1].length() || n3 == n2 + HA[2].length() || n3 == n2 + HA[3].length();
    }
}

