/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.internal.ii;
import com.google.android.gms.internal.ik;
import com.google.android.gms.internal.is;
import com.google.android.gms.internal.it;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class iq
extends ii {
    private static final String NAMESPACE = ik.aG("com.google.cast.media");
    private static final long Hb = TimeUnit.HOURS.toMillis(24L);
    private static final long Hc = TimeUnit.HOURS.toMillis(24L);
    private static final long Hd = TimeUnit.HOURS.toMillis(24L);
    private static final long He = TimeUnit.SECONDS.toMillis(1L);
    private long Hf;
    private MediaStatus Hg;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final it Hh;
    private final it Hi;
    private final it Hj;
    private final it Hk;
    private final it Hl;
    private final it Hm;
    private final it Hn;
    private final it Ho;
    private final it Hp;
    private final it Hq;
    private final List<it> Hr;
    private final Runnable Hs = new a();
    private boolean Ht;

    public iq() {
        this(null);
    }

    public iq(String string) {
        super(NAMESPACE, "MediaControlChannel", string);
        this.Hr = new ArrayList<it>();
        this.Hh = new it(Hc);
        this.Hr.add(this.Hh);
        this.Hi = new it(Hb);
        this.Hr.add(this.Hi);
        this.Hj = new it(Hb);
        this.Hr.add(this.Hj);
        this.Hk = new it(Hb);
        this.Hr.add(this.Hk);
        this.Hl = new it(Hd);
        this.Hr.add(this.Hl);
        this.Hm = new it(Hb);
        this.Hr.add(this.Hm);
        this.Hn = new it(Hb);
        this.Hr.add(this.Hn);
        this.Ho = new it(Hb);
        this.Hr.add(this.Ho);
        this.Hp = new it(Hb);
        this.Hr.add(this.Hp);
        this.Hq = new it(Hb);
        this.Hr.add(this.Hq);
        this.fU();
    }

    public long a(is is2, MediaInfo mediaInfo, boolean bl2, long l2, long[] lArray, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.fA();
        this.Hh.a(l3, is2);
        this.H(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.bL());
            jSONObject2.put("autoplay", bl2);
            jSONObject2.put("currentTime", ik.o(l2));
            if (lArray != null && lArray.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    jSONArray.put(i2, lArray[i2]);
                }
                jSONObject2.put("activeTrackIds", (Object)jSONArray);
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(is is2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fA();
        this.Hi.a(l2, is2);
        this.H(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.fx());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long b(is is2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fA();
        this.Hk.a(l2, is2);
        this.H(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.fx());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long c(is is2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fA();
        this.Hj.a(l2, is2);
        this.H(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.fx());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(is is2, long l2, int n2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.fA();
        this.Hl.a(l3, is2);
        this.H(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.fx());
            jSONObject2.put("currentTime", ik.o(l2));
            if (n2 == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n2 == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(is is2, double d2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fA();
        this.Hm.a(l2, is2);
        this.H(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.fx());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(is is2, boolean bl2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.fA();
        this.Hn.a(l2, is2);
        this.H(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.fx());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(is is2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.fA();
        this.Ho.a(l2, is2);
        this.H(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.Hg != null) {
                jSONObject.put("mediaSessionId", this.Hg.fx());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(is is2, long[] lArray) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.fA();
        this.Hp.a(l2, is2);
        this.H(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            jSONObject.put("mediaSessionId", this.fx());
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                jSONArray.put(i2, lArray[i2]);
            }
            jSONObject.put("activeTrackIds", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long a(is is2, TextTrackStyle textTrackStyle) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.fA();
        this.Hq.a(l2, is2);
        this.H(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"EDIT_TRACKS_INFO");
            if (textTrackStyle != null) {
                jSONObject.put("textTrackStyle", (Object)textTrackStyle.bL());
            }
            jSONObject.put("mediaSessionId", this.fx());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.Hf == 0L) {
            return 0L;
        }
        double d2 = this.Hg.getPlaybackRate();
        long l2 = this.Hg.getStreamPosition();
        int n2 = this.Hg.getPlayerState();
        if (d2 == 0.0 || n2 != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.Hf;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = mediaInfo.getStreamDuration();
        long l5 = l2 + (long)((double)l3 * d2);
        if (l4 > 0L && l5 > l4) {
            l5 = l4;
        } else if (l5 < 0L) {
            l5 = 0L;
        }
        return l5;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.Hg;
    }

    public MediaInfo getMediaInfo() {
        return this.Hg == null ? null : this.Hg.getMediaInfo();
    }

    @Override
    public final void aD(String string) {
        this.Go.b("message received: %s", string);
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string2 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string2.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.a(l2, jSONArray.getJSONObject(0));
                } else {
                    this.Hg = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.Ho.d(l2, 0);
                }
            } else if (string2.equals("INVALID_PLAYER_STATE")) {
                this.Go.d("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                for (it it2 : this.Hr) {
                    it2.b(l2, 2100, jSONObject2);
                }
            } else if (string2.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.Hh.b(l2, 2100, jSONObject3);
            } else if (string2.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.Hh.b(l2, 2101, jSONObject4);
            } else if (string2.equals("INVALID_REQUEST")) {
                this.Go.d("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                for (it it3 : this.Hr) {
                    it3.b(l2, 2100, jSONObject5);
                }
            }
        }
        catch (JSONException jSONException) {
            this.Go.d("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string);
        }
    }

    @Override
    public void b(long l2, int n2) {
        for (it it2 : this.Hr) {
            it2.d(l2, n2);
        }
    }

    private void a(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl2 = this.Hh.p(l2);
        boolean bl3 = this.Hl.fW() && !this.Hl.p(l2);
        boolean bl4 = this.Hm.fW() && !this.Hm.p(l2) || this.Hn.fW() && !this.Hn.p(l2);
        int n2 = 0;
        if (bl3) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 1;
        }
        int n3 = 0;
        if (bl2 || this.Hg == null) {
            this.Hg = new MediaStatus(jSONObject);
            this.Hf = SystemClock.elapsedRealtime();
            n3 = 7;
        } else {
            n3 = this.Hg.a(jSONObject, n2);
        }
        if ((n3 & 1) != 0) {
            this.Hf = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 2) != 0) {
            this.Hf = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 4) != 0) {
            this.onMetadataUpdated();
        }
        for (it it2 : this.Hr) {
            it2.d(l2, 0);
        }
    }

    public long fx() throws IllegalStateException {
        if (this.Hg == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.Hg.fx();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void fU() {
        this.H(false);
        this.Hf = 0L;
        this.Hg = null;
        this.Hh.clear();
        this.Hl.clear();
        this.Hm.clear();
    }

    @Override
    public void fB() {
        this.fU();
    }

    private void H(boolean bl2) {
        if (this.Ht != bl2) {
            this.Ht = bl2;
            if (bl2) {
                this.mHandler.postDelayed(this.Hs, He);
            } else {
                this.mHandler.removeCallbacks(this.Hs);
            }
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object2;
            iq.this.Ht = false;
            long l2 = SystemClock.elapsedRealtime();
            for (Object object2 : iq.this.Hr) {
                ((it)object2).e(l2, 2102);
            }
            boolean bl2 = false;
            object2 = it.Hz;
            synchronized (object2) {
                for (it it2 : iq.this.Hr) {
                    if (!it2.fW()) continue;
                    bl2 = true;
                }
            }
            iq.this.H(bl2);
        }
    }
}

