/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.internal.ez;
import com.google.android.gms.internal.gj;
import com.google.android.gms.internal.gr;
import java.util.Locale;

@ez
public final class fw {
    public final int uS;
    public final boolean uT;
    public final boolean uU;
    public final String uV;
    public final String uW;
    public final boolean uX;
    public final boolean uY;
    public final boolean uZ;
    public final String va;
    public final String vb;
    public final int vc;
    public final int vd;
    public final int ve;
    public final int vf;
    public final int vg;
    public final int vh;
    public final float vi;
    public final int vj;
    public final int vk;
    public final double vl;
    public final boolean vm;
    public final boolean vn;
    public final int vo;

    public fw(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        this.uS = audioManager.getMode();
        this.uT = fw.a(packageManager, "geo:0,0?q=donuts") != null;
        this.uU = fw.a(packageManager, "http://www.google.com") != null;
        this.uV = telephonyManager.getNetworkOperator();
        this.uW = locale.getCountry();
        this.uX = gr.ds();
        this.uY = audioManager.isMusicActive();
        this.uZ = audioManager.isSpeakerphoneOn();
        this.va = locale.getLanguage();
        this.vb = fw.a(packageManager);
        this.vc = audioManager.getStreamVolume(3);
        this.vd = fw.a(context, connectivityManager, packageManager);
        this.ve = telephonyManager.getNetworkType();
        this.vf = telephonyManager.getPhoneType();
        this.vg = audioManager.getRingerMode();
        this.vh = audioManager.getStreamVolume(2);
        this.vi = displayMetrics.density;
        this.vj = displayMetrics.widthPixels;
        this.vk = displayMetrics.heightPixels;
        if (intent != null) {
            int n2 = intent.getIntExtra("status", -1);
            int n3 = intent.getIntExtra("level", -1);
            int n4 = intent.getIntExtra("scale", -1);
            this.vl = (float)n3 / (float)n4;
            this.vm = n2 == 2 || n2 == 5;
        } else {
            this.vl = -1.0;
            this.vm = false;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.vn = connectivityManager.isActiveNetworkMetered();
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            this.vo = networkInfo != null ? connectivityManager.getActiveNetworkInfo().getDetailedState().ordinal() : -1;
        } else {
            this.vn = false;
            this.vo = -1;
        }
    }

    private static String a(PackageManager packageManager) {
        ResolveInfo resolveInfo = fw.a(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int a(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n2 = -2;
        if (gj.a(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n2 = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n2;
    }

    private static ResolveInfo a(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

