/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntityCreator;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import java.io.IOException;

public final class SnapshotEntity
implements SafeParcelable,
Snapshot {
    public static final SnapshotEntityCreator CREATOR = new SnapshotEntityCreator();
    private final int BR;
    private final SnapshotMetadataEntity acW;
    private final SnapshotContents acX;

    public SnapshotEntity(SnapshotMetadata metadata, SnapshotContents contents) {
        this(2, metadata, contents);
    }

    SnapshotEntity(int versionCode, SnapshotMetadata metadata, SnapshotContents contents) {
        this.BR = versionCode;
        this.acW = new SnapshotMetadataEntity(metadata);
        this.acX = contents;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.acW;
    }

    @Override
    public Contents getContents() {
        return this.isClosed() ? null : this.acX.getContents();
    }

    @Override
    public SnapshotContents getSnapshotContents() {
        return this.isClosed() ? null : this.acX;
    }

    private boolean isClosed() {
        return this.acX.isClosed();
    }

    @Override
    public byte[] readFully() {
        try {
            return this.acX.readFully();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public boolean writeBytes(byte[] content) {
        return this.acX.writeBytes(content);
    }

    @Override
    public boolean modifyBytes(int dstOffset, byte[] content, int srcOffset, int count) {
        return this.acX.modifyBytes(dstOffset, content, srcOffset, count);
    }

    @Override
    public Snapshot freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotEntity.b(this);
    }

    static int b(Snapshot snapshot) {
        return m.hashCode(snapshot.getMetadata(), snapshot.getSnapshotContents());
    }

    public boolean equals(Object obj) {
        return SnapshotEntity.a(this, obj);
    }

    static boolean a(Snapshot snapshot, Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        if (snapshot == object) {
            return true;
        }
        Snapshot snapshot2 = (Snapshot)object;
        return m.equal(snapshot2.getMetadata(), snapshot.getMetadata()) && m.equal(snapshot2.getSnapshotContents(), snapshot.getSnapshotContents());
    }

    public String toString() {
        return SnapshotEntity.c(this);
    }

    static String c(Snapshot snapshot) {
        return m.h(snapshot).a("Metadata", snapshot.getMetadata()).a("HasContents", snapshot.getSnapshotContents() != null).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotEntityCreator.a(this, out, flags);
    }
}

