/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int BR;
    private final GameEntity aan;
    private final PlayerEntity acR;
    private final byte[] acw;
    private final String Xr;
    private final ArrayList<PlayerEntity> acS;
    private final int FD;
    private final long abO;
    private final long acT;
    private final Bundle acU;
    private final int Fa;

    public GameRequestEntity(GameRequest request) {
        this.BR = 2;
        this.aan = new GameEntity(request.getGame());
        this.acR = new PlayerEntity(request.getSender());
        this.Xr = request.getRequestId();
        this.FD = request.getType();
        this.abO = request.getCreationTimestamp();
        this.acT = request.getExpirationTimestamp();
        this.Fa = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.acw = null;
        } else {
            this.acw = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.acw, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n2 = list.size();
        this.acS = new ArrayList(n2);
        this.acU = new Bundle();
        for (int i2 = 0; i2 < n2; ++i2) {
            Player player = (Player)list.get(i2).freeze();
            String string = player.getPlayerId();
            this.acS.add((PlayerEntity)player);
            this.acU.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.BR = versionCode;
        this.aan = game;
        this.acR = sender;
        this.acw = data;
        this.Xr = requestId;
        this.acS = recipients;
        this.FD = type;
        this.abO = creationTimestamp;
        this.acT = expirationTimestamp;
        this.acU = recipientStatuses;
        this.Fa = status;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getRequestId() {
        return this.Xr;
    }

    @Override
    public Game getGame() {
        return this.aan;
    }

    @Override
    public Player getSender() {
        return this.acR;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.acS);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.acw;
    }

    @Override
    public int getType() {
        return this.FD;
    }

    @Override
    public long getCreationTimestamp() {
        return this.abO;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.acT;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.acU.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.Fa;
    }

    public Bundle lJ() {
        return this.acU;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    static int a(GameRequest gameRequest) {
        return m.hashCode(gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.b(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    static boolean a(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return m.equal(gameRequest2.getGame(), gameRequest.getGame()) && m.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && m.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && m.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.b(gameRequest2), GameRequestEntity.b(gameRequest)) && m.equal(gameRequest2.getType(), gameRequest.getType()) && m.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && m.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] b(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = gameRequest.getRecipientStatus(list.get(i2).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    static String c(GameRequest gameRequest) {
        return m.h(gameRequest).a("Game", gameRequest.getGame()).a("Sender", gameRequest.getSender()).a("Recipients", gameRequest.getRecipients()).a("Data", gameRequest.getData()).a("RequestId", gameRequest.getRequestId()).a("Type", gameRequest.getType()).a("CreationTimestamp", gameRequest.getCreationTimestamp()).a("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.a(this, dest, flags);
    }
}

