/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final QuestEntityCreator CREATOR = new QuestEntityCreator();
    private final int BR;
    private final GameEntity aan;
    private final String acG;
    private final long acH;
    private final Uri acI;
    private final String acJ;
    private final String Tg;
    private final long acK;
    private final long VZ;
    private final Uri acL;
    private final String acM;
    private final String mName;
    private final long acN;
    private final long acO;
    private final int mState;
    private final int FD;
    private final ArrayList<MilestoneEntity> acP;

    public QuestEntity(Quest quest) {
        this.BR = 2;
        this.aan = new GameEntity(quest.getGame());
        this.acG = quest.getQuestId();
        this.acH = quest.getAcceptedTimestamp();
        this.Tg = quest.getDescription();
        this.acI = quest.getBannerImageUri();
        this.acJ = quest.getBannerImageUrl();
        this.acK = quest.getEndTimestamp();
        this.acL = quest.getIconImageUri();
        this.acM = quest.getIconImageUrl();
        this.VZ = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.acN = quest.lI();
        this.acO = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.FD = quest.getType();
        List<Milestone> list = quest.lH();
        int n2 = list.size();
        this.acP = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.acP.add((MilestoneEntity)list.get(i2).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.BR = versionCode;
        this.aan = game;
        this.acG = questId;
        this.acH = acceptedTimestamp;
        this.acI = bannerImageUri;
        this.acJ = bannerImageUrl;
        this.Tg = description;
        this.acK = endTimestamp;
        this.VZ = lastUpdatedTimestamp;
        this.acL = iconImageUri;
        this.acM = iconImageUrl;
        this.mName = name;
        this.acN = notifyTimestamp;
        this.acO = startTimestamp;
        this.mState = state;
        this.FD = type;
        this.acP = milestones;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getQuestId() {
        return this.acG;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        jv.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Tg;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tg, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.acL;
    }

    @Override
    public String getIconImageUrl() {
        return this.acM;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.acI;
    }

    @Override
    public String getBannerImageUrl() {
        return this.acJ;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.lH().get(0);
    }

    @Override
    public List<Milestone> lH() {
        return new ArrayList<Milestone>(this.acP);
    }

    @Override
    public Game getGame() {
        return this.aan;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.FD;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.acH;
    }

    @Override
    public long getEndTimestamp() {
        return this.acK;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.VZ;
    }

    @Override
    public long lI() {
        return this.acN;
    }

    @Override
    public long getStartTimestamp() {
        return this.acO;
    }

    @Override
    public boolean isEndingSoon() {
        return this.acN <= System.currentTimeMillis() + 1800000L;
    }

    @Override
    public Quest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.a(this);
    }

    static int a(Quest quest) {
        return m.hashCode(quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.lH(), quest.getName(), quest.lI(), quest.getStartTimestamp(), quest.getState());
    }

    public boolean equals(Object obj) {
        return QuestEntity.a(this, obj);
    }

    static boolean a(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return m.equal(quest2.getGame(), quest.getGame()) && m.equal(quest2.getQuestId(), quest.getQuestId()) && m.equal(quest2.getAcceptedTimestamp(), quest.getAcceptedTimestamp()) && m.equal(quest2.getBannerImageUri(), quest.getBannerImageUri()) && m.equal(quest2.getDescription(), quest.getDescription()) && m.equal(quest2.getEndTimestamp(), quest.getEndTimestamp()) && m.equal(quest2.getIconImageUri(), quest.getIconImageUri()) && m.equal(quest2.getLastUpdatedTimestamp(), quest.getLastUpdatedTimestamp()) && m.equal(quest2.lH(), quest.lH()) && m.equal(quest2.getName(), quest.getName()) && m.equal(quest2.lI(), quest.lI()) && m.equal(quest2.getStartTimestamp(), quest.getStartTimestamp()) && m.equal(quest2.getState(), quest.getState());
    }

    public String toString() {
        return QuestEntity.b(this);
    }

    static String b(Quest quest) {
        return m.h(quest).a("Game", quest.getGame()).a("QuestId", quest.getQuestId()).a("AcceptedTimestamp", quest.getAcceptedTimestamp()).a("BannerImageUri", quest.getBannerImageUri()).a("BannerImageUrl", quest.getBannerImageUrl()).a("Description", quest.getDescription()).a("EndTimestamp", quest.getEndTimestamp()).a("IconImageUri", quest.getIconImageUri()).a("IconImageUrl", quest.getIconImageUrl()).a("LastUpdatedTimestamp", quest.getLastUpdatedTimestamp()).a("Milestones", quest.lH()).a("Name", quest.getName()).a("NotifyTimestamp", quest.lI()).a("StartTimestamp", quest.getStartTimestamp()).a("State", quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.a(this, out, flags);
    }
}

