/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int BR;
    private final GameEntity aan;
    private final String WW;
    private final String acl;
    private final long abO;
    private final String act;
    private final long VZ;
    private final String acu;
    private final int acv;
    private final int abS;
    private final int Di;
    private final byte[] acw;
    private final ArrayList<ParticipantEntity> abR;
    private final String acx;
    private final byte[] acy;
    private final int acz;
    private final Bundle ach;
    private final int acA;
    private final boolean acB;
    private final String Tg;
    private final String acC;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.BR = 2;
        this.aan = new GameEntity(match.getGame());
        this.WW = match.getMatchId();
        this.acl = match.getCreatorId();
        this.abO = match.getCreationTimestamp();
        this.act = match.getLastUpdaterId();
        this.VZ = match.getLastUpdatedTimestamp();
        this.acu = match.getPendingParticipantId();
        this.acv = match.getStatus();
        this.acA = match.getTurnStatus();
        this.abS = match.getVariant();
        this.Di = match.getVersion();
        this.acx = match.getRematchId();
        this.acz = match.getMatchNumber();
        this.ach = match.getAutoMatchCriteria();
        this.acB = match.isLocallyModified();
        this.Tg = match.getDescription();
        this.acC = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.acw = null;
        } else {
            this.acw = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.acw, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.acy = null;
        } else {
            this.acy = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.acy, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.abR = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.abR.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.BR = versionCode;
        this.aan = game;
        this.WW = matchId;
        this.acl = creatorId;
        this.abO = creationTimestamp;
        this.act = lastUpdaterId;
        this.VZ = lastUpdatedTimestamp;
        this.acu = pendingParticipantId;
        this.acv = matchStatus;
        this.acA = turnStatus;
        this.abS = variant;
        this.Di = version;
        this.acw = data;
        this.abR = participants;
        this.acx = rematchId;
        this.acy = previousData;
        this.acz = matchNumber;
        this.ach = autoMatchCriteria;
        this.acB = isLocallyModified;
        this.Tg = description;
        this.acC = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public Game getGame() {
        return this.aan;
    }

    @Override
    public String getMatchId() {
        return this.WW;
    }

    @Override
    public String getCreatorId() {
        return this.acl;
    }

    @Override
    public long getCreationTimestamp() {
        return this.abO;
    }

    @Override
    public String getLastUpdaterId() {
        return this.act;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.VZ;
    }

    @Override
    public String getPendingParticipantId() {
        return this.acu;
    }

    @Override
    public int getStatus() {
        return this.acv;
    }

    @Override
    public int getTurnStatus() {
        return this.acA;
    }

    @Override
    public String getDescription() {
        return this.Tg;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.acC;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tg, dataOut);
    }

    @Override
    public int getVariant() {
        return this.abS;
    }

    @Override
    public byte[] getData() {
        return this.acw;
    }

    @Override
    public int getVersion() {
        return this.Di;
    }

    @Override
    public String getRematchId() {
        return this.acx;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.acy;
    }

    @Override
    public int getMatchNumber() {
        return this.acz;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.ach;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.ach == null) {
            return 0;
        }
        return this.ach.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.acv == 2 && this.acx == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.acB;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.abR);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return m.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return m.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && m.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && m.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && m.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && m.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && m.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && m.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && m.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && m.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && m.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && m.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && m.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && m.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && m.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && m.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && m.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && m.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && m.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return m.h(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Description", turnBasedMatch.getDescription()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).a("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }
}

