/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.internal.n;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int abS;
    private final String[] acg;
    private final Bundle ach;
    private final int acs;

    private TurnBasedMatchConfig(Builder builder) {
        this.abS = builder.abS;
        this.acs = builder.acs;
        this.ach = builder.ach;
        int n2 = builder.ack.size();
        this.acg = builder.ack.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.abS;
    }

    public int lF() {
        return this.acs;
    }

    public String[] getInvitedPlayerIds() {
        return this.acg;
    }

    public Bundle getAutoMatchCriteria() {
        return this.ach;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int abS = -1;
        ArrayList<String> ack = new ArrayList();
        Bundle ach = null;
        int acs = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            n.i(playerId);
            this.ack.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            n.i(playerIds);
            this.ack.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            n.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.abS = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.ach = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

