/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer aco;
    private final TurnBasedMatchBuffer acp;
    private final TurnBasedMatchBuffer acq;
    private final TurnBasedMatchBuffer acr;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.a(matchData, 0);
        this.aco = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.a(matchData, 1);
        this.acp = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.a(matchData, 2);
        this.acq = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.a(matchData, 3);
        this.acr = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder a(Bundle bundle, int n2) {
        String string = TurnBasedMatchTurnStatus.dH(n2);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.aco;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.acp;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.acq;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.acr;
    }

    public void close() {
        if (this.aco != null) {
            this.aco.close();
        }
        if (this.acp != null) {
            this.acp.close();
        }
        if (this.acq != null) {
            this.acq.close();
        }
        if (this.acr != null) {
            this.acr.close();
        }
    }

    public boolean hasData() {
        if (this.aco != null && this.aco.getCount() > 0) {
            return true;
        }
        if (this.acp != null && this.acp.getCount() > 0) {
            return true;
        }
        if (this.acq != null && this.acq.getCount() > 0) {
            return true;
        }
        return this.acr != null && this.acr.getCount() > 0;
    }
}

