/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import java.util.ArrayList;

public final class RoomRef
extends d
implements Room {
    private final int aaz;

    RoomRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.aaz = numChildren;
    }

    @Override
    public String getRoomId() {
        return this.getString("external_match_id");
    }

    @Override
    public String getCreatorId() {
        return this.getString("creator_external");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public String getDescription() {
        return this.getString("description");
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        this.a("description", dataOut);
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return null;
        }
        int n2 = this.getInteger("automatch_min_players");
        int n3 = this.getInteger("automatch_max_players");
        long l2 = this.getLong("automatch_bit_mask");
        return RoomConfig.createAutoMatchCriteria(n2, n3, l2);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        ArrayList<Participant> arrayList = new ArrayList<Participant>(this.aaz);
        for (int i2 = 0; i2 < this.aaz; ++i2) {
            arrayList.add(new ParticipantRef(this.IC, this.JQ + i2));
        }
        return arrayList;
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.getInteger("automatch_wait_estimate_sec");
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.a((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.c(this, participantId);
    }

    @Override
    public Room freeze() {
        return new RoomEntity(this);
    }

    @Override
    public int hashCode() {
        return RoomEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return RoomEntity.a((Room)this, obj);
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        RoomEntity roomEntity = (RoomEntity)this.freeze();
        roomEntity.writeToParcel(dest, flags);
    }
}

