/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int BR;
    private final String WF;
    private final String acl;
    private final long abO;
    private final int acm;
    private final String Tg;
    private final int abS;
    private final Bundle ach;
    private final ArrayList<ParticipantEntity> abR;
    private final int acn;

    public RoomEntity(Room room) {
        this.BR = 2;
        this.WF = room.getRoomId();
        this.acl = room.getCreatorId();
        this.abO = room.getCreationTimestamp();
        this.acm = room.getStatus();
        this.Tg = room.getDescription();
        this.abS = room.getVariant();
        this.ach = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.abR = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.abR.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
        this.acn = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.BR = versionCode;
        this.WF = roomId;
        this.acl = creatorId;
        this.abO = creationTimestamp;
        this.acm = roomStatus;
        this.Tg = description;
        this.abS = variant;
        this.ach = autoMatchCriteria;
        this.abR = participants;
        this.acn = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getRoomId() {
        return this.WF;
    }

    @Override
    public String getCreatorId() {
        return this.acl;
    }

    @Override
    public long getCreationTimestamp() {
        return this.abO;
    }

    @Override
    public int getStatus() {
        return this.acm;
    }

    @Override
    public String getDescription() {
        return this.Tg;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tg, dataOut);
    }

    @Override
    public int getVariant() {
        return this.abS;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.ach;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.abR);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.acn;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.a((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.c(this, participantId);
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    static int a(Room room) {
        return m.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a((Room)this, obj);
    }

    static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return m.equal(room2.getRoomId(), room.getRoomId()) && m.equal(room2.getCreatorId(), room.getCreatorId()) && m.equal(room2.getCreationTimestamp(), room.getCreationTimestamp()) && m.equal(room2.getStatus(), room.getStatus()) && m.equal(room2.getDescription(), room.getDescription()) && m.equal(room2.getVariant(), room.getVariant()) && m.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && m.equal(room2.getParticipants(), room.getParticipants()) && m.equal(room2.getAutoMatchWaitEstimateSeconds(), room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    static String b(Room room) {
        return m.h(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).a("AutoMatchWaitEstimateSeconds", room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            RoomEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.WF);
            dest.writeString(this.acl);
            dest.writeLong(this.abO);
            dest.writeInt(this.acm);
            dest.writeString(this.Tg);
            dest.writeInt(this.abS);
            dest.writeBundle(this.ach);
            int n2 = this.abR.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.abR.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static int a(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> c(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant c(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity co(Parcel parcel) {
            int n2;
            boolean bl2 = RoomEntity.c(RoomEntity.gP());
            if (bl2 || RoomEntity.aV(RoomEntity.class.getCanonicalName())) {
                return super.co(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            String string3 = parcel.readString();
            int n4 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n5 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            return new RoomEntity(2, string, string2, l2, n3, string3, n4, bundle, arrayList, n2);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.co(x0);
        }
    }
}

