/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener acd;
    private final RoomStatusUpdateListener ace;
    private final RealTimeMessageReceivedListener acf;
    private final String WD;
    private final int abS;
    private final String[] acg;
    private final Bundle ach;
    private final boolean aci;

    private RoomConfig(Builder builder) {
        this.acd = builder.acd;
        this.ace = builder.ace;
        this.acf = builder.acf;
        this.WD = builder.acj;
        this.abS = builder.abS;
        this.ach = builder.ach;
        this.aci = builder.aci;
        int n2 = builder.ack.size();
        this.acg = builder.ack.toArray(new String[n2]);
        if (this.acf == null) {
            n.a(this.aci, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.acd;
    }

    public String getInvitationId() {
        return this.WD;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.ace;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.acf;
    }

    public int getVariant() {
        return this.abS;
    }

    public String[] getInvitedPlayerIds() {
        return this.acg;
    }

    public Bundle getAutoMatchCriteria() {
        return this.ach;
    }

    public boolean isSocketEnabled() {
        return this.aci;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener acd;
        RoomStatusUpdateListener ace;
        RealTimeMessageReceivedListener acf;
        String acj = null;
        int abS = -1;
        ArrayList<String> ack = new ArrayList();
        Bundle ach;
        boolean aci = false;

        private Builder(RoomUpdateListener updateListener) {
            this.acd = n.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            n.i(invitationId);
            this.acj = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.ace = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.acf = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            n.i(playerIds);
            this.ack.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            n.i(playerIds);
            this.ack.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            n.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.abS = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.aci = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.ach = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

