/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.jv;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int BR;
    private final String Xg;
    private final String Nz;
    private final Uri UW;
    private final Uri UX;
    private final int Fa;
    private final String Wf;
    private final boolean abV;
    private final PlayerEntity VW;
    private final int EZ;
    private final ParticipantResult abW;
    private final String Vh;
    private final String Vi;

    public ParticipantEntity(Participant participant) {
        this.BR = 3;
        this.Xg = participant.getParticipantId();
        this.Nz = participant.getDisplayName();
        this.UW = participant.getIconImageUri();
        this.UX = participant.getHiResImageUri();
        this.Fa = participant.getStatus();
        this.Wf = participant.jU();
        this.abV = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.VW = player == null ? null : new PlayerEntity(player);
        this.EZ = participant.getCapabilities();
        this.abW = participant.getResult();
        this.Vh = participant.getIconImageUrl();
        this.Vi = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.BR = versionCode;
        this.Xg = participantId;
        this.Nz = displayName;
        this.UW = iconImageUri;
        this.UX = hiResImageUri;
        this.Fa = status;
        this.Wf = clientAddress;
        this.abV = connectedToRoom;
        this.VW = player;
        this.EZ = capabilities;
        this.abW = result;
        this.Vh = iconImageUrl;
        this.Vi = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public int getStatus() {
        return this.Fa;
    }

    @Override
    public String jU() {
        return this.Wf;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.abV;
    }

    @Override
    public String getDisplayName() {
        if (this.VW == null) {
            return this.Nz;
        }
        return this.VW.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.VW == null) {
            jv.b(this.Nz, dataOut);
            return;
        }
        this.VW.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.VW == null) {
            return this.UW;
        }
        return this.VW.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.VW == null) {
            return this.Vh;
        }
        return this.VW.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.VW == null) {
            return this.UX;
        }
        return this.VW.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.VW == null) {
            return this.Vi;
        }
        return this.VW.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.Xg;
    }

    @Override
    public Player getPlayer() {
        return this.VW;
    }

    @Override
    public ParticipantResult getResult() {
        return this.abW;
    }

    @Override
    public int getCapabilities() {
        return this.EZ;
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return m.hashCode(participant.getPlayer(), participant.getStatus(), participant.jU(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return m.equal(participant2.getPlayer(), participant.getPlayer()) && m.equal(participant2.getStatus(), participant.getStatus()) && m.equal(participant2.jU(), participant.jU()) && m.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && m.equal(participant2.getDisplayName(), participant.getDisplayName()) && m.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && m.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && m.equal(participant2.getCapabilities(), participant.getCapabilities()) && m.equal(participant2.getResult(), participant.getResult()) && m.equal(participant2.getParticipantId(), participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return m.h(participant).a("ParticipantId", participant.getParticipantId()).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.jU()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("IconImageUrl", participant.getIconImageUrl()).a("HiResImage", participant.getHiResImageUri()).a("HiResImageUrl", participant.getHiResImageUrl()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            ParticipantEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Xg);
            dest.writeString(this.Nz);
            dest.writeString(this.UW == null ? null : this.UW.toString());
            dest.writeString(this.UX == null ? null : this.UX.toString());
            dest.writeInt(this.Fa);
            dest.writeString(this.Wf);
            dest.writeInt(this.abV ? 1 : 0);
            dest.writeInt(this.VW == null ? 0 : 1);
            if (this.VW != null) {
                this.VW.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity cm(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.gP());
            if (bl2 || ParticipantEntity.aV(ParticipantEntity.class.getCanonicalName())) {
                return super.cm(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n2 = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n2, string5, bl3, playerEntity, n3, participantResult, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cm(x0);
        }
    }
}

