/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantRef;
import java.util.ArrayList;

public final class InvitationRef
extends d
implements Invitation {
    private final Game abm;
    private final ParticipantRef abU;
    private final ArrayList<Participant> abR;

    InvitationRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.abm = new GameRef(holder, dataRow);
        this.abR = new ArrayList(numChildren);
        ParticipantRef participantRef = null;
        String string = this.getString("external_inviter_id");
        for (int i2 = 0; i2 < numChildren; ++i2) {
            ParticipantRef participantRef2 = new ParticipantRef(this.IC, this.JQ + i2);
            if (participantRef2.getParticipantId().equals(string)) {
                participantRef = participantRef2;
            }
            this.abR.add(participantRef2);
        }
        this.abU = n.b(participantRef, (Object)"Must have a valid inviter!");
    }

    @Override
    public Game getGame() {
        return this.abm;
    }

    @Override
    public String getInvitationId() {
        return this.getString("external_invitation_id");
    }

    @Override
    public Participant getInviter() {
        return this.abU;
    }

    @Override
    public long getCreationTimestamp() {
        long l2 = this.getLong("creation_timestamp");
        long l3 = this.getLong("last_modified_timestamp");
        return Math.max(l2, l3);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return this.abR;
    }

    @Override
    public int getInvitationType() {
        return this.getInteger("type");
    }

    @Override
    public int getVariant() {
        return this.getInteger("variant");
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (!this.getBoolean("has_automatch_criteria")) {
            return 0;
        }
        return this.getInteger("automatch_max_players");
    }

    @Override
    public Invitation freeze() {
        return new InvitationEntity(this);
    }

    @Override
    public int hashCode() {
        return InvitationEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        InvitationEntity invitationEntity = (InvitationEntity)this.freeze();
        invitationEntity.writeToParcel(dest, flags);
    }
}

