/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int BR;
    private final GameEntity aan;
    private final String WD;
    private final long abO;
    private final int abP;
    private final ParticipantEntity abQ;
    private final ArrayList<ParticipantEntity> abR;
    private final int abS;
    private final int abT;

    InvitationEntity(Invitation invitation) {
        this.BR = 2;
        this.aan = new GameEntity(invitation.getGame());
        this.WD = invitation.getInvitationId();
        this.abO = invitation.getCreationTimestamp();
        this.abP = invitation.getInvitationType();
        this.abS = invitation.getVariant();
        this.abT = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.abR = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.abR.add((ParticipantEntity)participant2.freeze());
        }
        n.b(participant, (Object)"Must have a valid inviter!");
        this.abQ = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.BR = versionCode;
        this.aan = game;
        this.WD = invitationId;
        this.abO = creationTimestamp;
        this.abP = invitationType;
        this.abQ = inviter;
        this.abR = participants;
        this.abS = variant;
        this.abT = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public Game getGame() {
        return this.aan;
    }

    @Override
    public String getInvitationId() {
        return this.WD;
    }

    @Override
    public Participant getInviter() {
        return this.abQ;
    }

    @Override
    public long getCreationTimestamp() {
        return this.abO;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.abR);
    }

    @Override
    public int getInvitationType() {
        return this.abP;
    }

    @Override
    public int getVariant() {
        return this.abS;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.abT;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return m.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return m.equal(invitation2.getGame(), invitation.getGame()) && m.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && m.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && m.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && m.equal(invitation2.getInviter(), invitation.getInviter()) && m.equal(invitation2.getParticipants(), invitation.getParticipants()) && m.equal(invitation2.getVariant(), invitation.getVariant()) && m.equal(invitation2.getAvailableAutoMatchSlots(), invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return m.h(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).a("AvailableAutoMatchSlots", invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            InvitationEntityCreator.a(this, dest, flags);
        } else {
            this.aan.writeToParcel(dest, flags);
            dest.writeString(this.WD);
            dest.writeLong(this.abO);
            dest.writeInt(this.abP);
            this.abQ.writeToParcel(dest, flags);
            int n2 = this.abR.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.abR.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity cl(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.gP());
            if (bl2 || InvitationEntity.aV(InvitationEntity.class.getCanonicalName())) {
                return super.cl(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            int n5 = 0;
            return new InvitationEntity(2, gameEntity, string, l2, n3, participantEntity, arrayList, n2, n5);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cl(x0);
        }
    }
}

