/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.jv;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long abo;
    private final String abp;
    private final String abq;
    private final long abr;
    private final long abs;
    private final String abt;
    private final Uri abu;
    private final Uri abv;
    private final PlayerEntity abw;
    private final String abx;
    private final String aby;
    private final String abz;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.abo = score.getRank();
        this.abp = n.i(score.getDisplayRank());
        this.abq = n.i(score.getDisplayScore());
        this.abr = score.getRawScore();
        this.abs = score.getTimestampMillis();
        this.abt = score.getScoreHolderDisplayName();
        this.abu = score.getScoreHolderIconImageUri();
        this.abv = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.abw = player == null ? null : (PlayerEntity)player.freeze();
        this.abx = score.getScoreTag();
        this.aby = score.getScoreHolderIconImageUrl();
        this.abz = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.abo;
    }

    @Override
    public String getDisplayRank() {
        return this.abp;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        jv.b(this.abp, dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.abq;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        jv.b(this.abq, dataOut);
    }

    @Override
    public long getRawScore() {
        return this.abr;
    }

    @Override
    public long getTimestampMillis() {
        return this.abs;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.abw == null) {
            return this.abt;
        }
        return this.abw.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.abw == null) {
            jv.b(this.abt, dataOut);
            return;
        }
        this.abw.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.abw == null) {
            return this.abu;
        }
        return this.abw.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.abw == null) {
            return this.aby;
        }
        return this.abw.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.abw == null) {
            return this.abv;
        }
        return this.abw.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.abw == null) {
            return this.abz;
        }
        return this.abw.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.abw;
    }

    @Override
    public String getScoreTag() {
        return this.abx;
    }

    public LeaderboardScore lA() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return m.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return m.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && m.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && m.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && m.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && m.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && m.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && m.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && m.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && m.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && m.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return m.h(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.lA();
    }
}

