/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.jv;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String abj;
    private final String Nz;
    private final Uri UW;
    private final int abk;
    private final ArrayList<LeaderboardVariantEntity> abl;
    private final Game abm;
    private final String Vh;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.abj = leaderboard.getLeaderboardId();
        this.Nz = leaderboard.getDisplayName();
        this.UW = leaderboard.getIconImageUri();
        this.Vh = leaderboard.getIconImageUrl();
        this.abk = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.abm = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n2 = arrayList.size();
        this.abl = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.abl.add((LeaderboardVariantEntity)arrayList.get(i2).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.abj;
    }

    @Override
    public String getDisplayName() {
        return this.Nz;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        jv.b(this.Nz, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.UW;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vh;
    }

    @Override
    public int getScoreOrder() {
        return this.abk;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.abl);
    }

    @Override
    public Game getGame() {
        return this.abm;
    }

    public Leaderboard lx() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.a(this);
    }

    static int a(Leaderboard leaderboard) {
        return m.hashCode(leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants());
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.a(this, obj);
    }

    static boolean a(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return m.equal(leaderboard2.getLeaderboardId(), leaderboard.getLeaderboardId()) && m.equal(leaderboard2.getDisplayName(), leaderboard.getDisplayName()) && m.equal(leaderboard2.getIconImageUri(), leaderboard.getIconImageUri()) && m.equal(leaderboard2.getScoreOrder(), leaderboard.getScoreOrder()) && m.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.b(this);
    }

    static String b(Leaderboard leaderboard) {
        return m.h(leaderboard).a("LeaderboardId", leaderboard.getLeaderboardId()).a("DisplayName", leaderboard.getDisplayName()).a("IconImageUri", leaderboard.getIconImageUri()).a("IconImageUrl", leaderboard.getIconImageUrl()).a("ScoreOrder", leaderboard.getScoreOrder()).a("Variants", leaderboard.getVariants()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.lx();
    }
}

