/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.ExtendedGame;
import com.google.android.gms.games.internal.game.ExtendedGameEntityCreator;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import java.util.ArrayList;

public final class ExtendedGameEntity
extends GamesDowngradeableSafeParcel
implements ExtendedGame {
    public static final ExtendedGameEntityCreator CREATOR = new ExtendedGameEntityCreatorCompat();
    private final int BR;
    private final GameEntity aan;
    private final int aao;
    private final boolean aap;
    private final int aaq;
    private final long aar;
    private final long aas;
    private final String aat;
    private final long aau;
    private final String aav;
    private final ArrayList<GameBadgeEntity> aaw;
    private final SnapshotMetadataEntity aax;

    public ExtendedGameEntity(ExtendedGame extendedGame) {
        this.BR = 2;
        Game game = extendedGame.getGame();
        this.aan = game == null ? null : new GameEntity(game);
        this.aao = extendedGame.kP();
        this.aap = extendedGame.kQ();
        this.aaq = extendedGame.kR();
        this.aar = extendedGame.kS();
        this.aas = extendedGame.kT();
        this.aat = extendedGame.kU();
        this.aau = extendedGame.kV();
        this.aav = extendedGame.kW();
        SnapshotMetadata snapshotMetadata = extendedGame.kX();
        this.aax = snapshotMetadata == null ? null : new SnapshotMetadataEntity(snapshotMetadata);
        ArrayList<GameBadge> arrayList = extendedGame.kO();
        int n2 = arrayList.size();
        this.aaw = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.aaw.add((GameBadgeEntity)arrayList.get(i2).freeze());
        }
    }

    ExtendedGameEntity(int versionCode, GameEntity game, int availability, boolean owned, int achievementUnlockedCount, long lastPlayedServerTimestamp, long priceMicros, String formattedPrice, long fullPriceMicros, String formattedFullPrice, ArrayList<GameBadgeEntity> badges, SnapshotMetadataEntity snapshot) {
        this.BR = versionCode;
        this.aan = game;
        this.aao = availability;
        this.aap = owned;
        this.aaq = achievementUnlockedCount;
        this.aar = lastPlayedServerTimestamp;
        this.aas = priceMicros;
        this.aat = formattedPrice;
        this.aau = fullPriceMicros;
        this.aav = formattedFullPrice;
        this.aaw = badges;
        this.aax = snapshot;
    }

    public int getVersionCode() {
        return this.BR;
    }

    public GameEntity kY() {
        return this.aan;
    }

    @Override
    public ArrayList<GameBadge> kO() {
        return new ArrayList<GameBadge>(this.aaw);
    }

    @Override
    public int kP() {
        return this.aao;
    }

    @Override
    public boolean kQ() {
        return this.aap;
    }

    @Override
    public int kR() {
        return this.aaq;
    }

    @Override
    public long kS() {
        return this.aar;
    }

    @Override
    public long kT() {
        return this.aas;
    }

    @Override
    public String kU() {
        return this.aat;
    }

    @Override
    public long kV() {
        return this.aau;
    }

    @Override
    public String kW() {
        return this.aav;
    }

    @Override
    public SnapshotMetadata kX() {
        return this.aax;
    }

    public ExtendedGame kZ() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ExtendedGameEntity.a(this);
    }

    static int a(ExtendedGame extendedGame) {
        return m.hashCode(extendedGame.getGame(), extendedGame.kP(), extendedGame.kQ(), extendedGame.kR(), extendedGame.kS(), extendedGame.kT(), extendedGame.kU(), extendedGame.kV(), extendedGame.kW());
    }

    public boolean equals(Object obj) {
        return ExtendedGameEntity.a(this, obj);
    }

    static boolean a(ExtendedGame extendedGame, Object object) {
        if (!(object instanceof ExtendedGame)) {
            return false;
        }
        if (extendedGame == object) {
            return true;
        }
        ExtendedGame extendedGame2 = (ExtendedGame)object;
        return m.equal(extendedGame2.getGame(), extendedGame.getGame()) && m.equal(extendedGame2.kP(), extendedGame.kP()) && m.equal(extendedGame2.kQ(), extendedGame.kQ()) && m.equal(extendedGame2.kR(), extendedGame.kR()) && m.equal(extendedGame2.kS(), extendedGame.kS()) && m.equal(extendedGame2.kT(), extendedGame.kT()) && m.equal(extendedGame2.kU(), extendedGame.kU()) && m.equal(extendedGame2.kV(), extendedGame.kV()) && m.equal(extendedGame2.kW(), extendedGame.kW());
    }

    public String toString() {
        return ExtendedGameEntity.b(this);
    }

    static String b(ExtendedGame extendedGame) {
        return m.h(extendedGame).a("Game", extendedGame.getGame()).a("Availability", extendedGame.kP()).a("Owned", extendedGame.kQ()).a("AchievementUnlockedCount", extendedGame.kR()).a("LastPlayedServerTimestamp", extendedGame.kS()).a("PriceMicros", extendedGame.kT()).a("FormattedPrice", extendedGame.kU()).a("FullPriceMicros", extendedGame.kV()).a("FormattedFullPrice", extendedGame.kW()).a("Snapshot", extendedGame.kX()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            ExtendedGameEntityCreator.a(this, dest, flags);
        } else {
            this.aan.writeToParcel(dest, flags);
            dest.writeInt(this.aao);
            dest.writeInt(this.aap ? 1 : 0);
            dest.writeInt(this.aaq);
            dest.writeLong(this.aar);
            dest.writeLong(this.aas);
            dest.writeString(this.aat);
            dest.writeLong(this.aau);
            dest.writeString(this.aav);
            int n2 = this.aaw.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.aaw.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    @Override
    public /* synthetic */ Game getGame() {
        return this.kY();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.kZ();
    }

    static final class ExtendedGameEntityCreatorCompat
    extends ExtendedGameEntityCreator {
        ExtendedGameEntityCreatorCompat() {
        }

        @Override
        public ExtendedGameEntity cg(Parcel parcel) {
            boolean bl2 = ExtendedGameEntity.c(ExtendedGameEntity.gP());
            if (bl2 || ExtendedGameEntity.aV(ExtendedGameEntity.class.getCanonicalName())) {
                return super.cg(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            boolean bl3 = parcel.readInt() == 1;
            int n3 = parcel.readInt();
            long l2 = parcel.readLong();
            long l3 = parcel.readLong();
            String string = parcel.readString();
            long l4 = parcel.readLong();
            String string2 = parcel.readString();
            int n4 = parcel.readInt();
            ArrayList<GameBadgeEntity> arrayList = new ArrayList<GameBadgeEntity>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add(GameBadgeEntity.CREATOR.ch(parcel));
            }
            SnapshotMetadataEntity snapshotMetadataEntity = null;
            return new ExtendedGameEntity(2, gameEntity, n2, bl3, n3, l2, l3, string, l4, string2, arrayList, snapshotMetadataEntity);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cg(x0);
        }
    }
}

