/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.internal.kc;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl XO;
    protected PopupLocationInfo XP;

    public static PopupManager a(GamesClientImpl gamesClientImpl, int n2) {
        if (kc.hC()) {
            return new PopupManagerHCMR1(gamesClientImpl, n2);
        }
        return new PopupManager(gamesClientImpl, n2);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int gravity) {
        this.XO = gamesClientImpl;
        this.dG(gravity);
    }

    protected void dG(int n2) {
        this.XP = new PopupLocationInfo(n2, (IBinder)new Binder());
    }

    public void setGravity(int gravity) {
        this.XP.gravity = gravity;
    }

    public void l(View view) {
    }

    public void kJ() {
        this.XO.a(this.XP.XQ, this.XP.kM());
    }

    public Bundle kK() {
        return this.XP.kM();
    }

    public IBinder kL() {
        return this.XP.XQ;
    }

    public static final class PopupLocationInfo {
        public IBinder XQ;
        public int gravity;
        public int XR = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int gravity, IBinder windowToken) {
            this.gravity = gravity;
            this.XQ = windowToken;
        }

        public Bundle kM() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.XR);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> XS;
        private boolean Wn = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int gravity) {
            super(gamesClientImpl, gravity);
        }

        @Override
        protected void dG(int n2) {
            this.XP = new PopupLocationInfo(n2, null);
        }

        @Override
        public void l(View view) {
            Context context;
            View view2;
            this.XO.ku();
            if (this.XS != null) {
                view2 = (View)this.XS.get();
                context = this.XO.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (kc.hF()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.XS = null;
            view2 = this.XO.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.p("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view which may not work properly in future versions of the API. Use setViewForPopups() to set your content view.");
            }
            if (view != null) {
                this.m(view);
                this.XS = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.q("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void kJ() {
            if (this.XP.XQ != null) {
                super.kJ();
                return;
            }
            this.Wn = this.XS != null;
        }

        public void onViewAttachedToWindow(View v2) {
            this.m(v2);
        }

        public void onViewDetachedFromWindow(View v2) {
            this.XO.ku();
            v2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.XS == null) {
                return;
            }
            View view = (View)this.XS.get();
            if (view == null) {
                return;
            }
            this.m(view);
        }

        private void m(View view) {
            Display display;
            int n2 = -1;
            if (kc.hG()) {
                display = view.getDisplay();
                n2 = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n3 = view.getWidth();
            int n4 = view.getHeight();
            this.XP.XR = n2;
            this.XP.XQ = display;
            this.XP.left = nArray[0];
            this.XP.top = nArray[1];
            this.XP.right = nArray[0] + n3;
            this.XP.bottom = nArray[1] + n4;
            if (this.Wn) {
                this.kJ();
                this.Wn = false;
            }
        }
    }
}

