/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.BaseImplementation;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.a;
import com.google.android.gms.common.internal.d;
import com.google.android.gms.common.internal.k;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.OnNearbyPlayerDetectedListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.event.EventBuffer;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.LibjingleNativeSocket;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.RealTimeSocketImpl;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.events.EventIncrementCache;
import com.google.android.gms.games.internal.events.EventIncrementManager;
import com.google.android.gms.games.internal.experience.ExperienceEventBuffer;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.ExtendedGameBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestBuffer;
import com.google.android.gms.games.quest.QuestEntity;
import com.google.android.gms.games.quest.QuestUpdateListener;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataBuffer;
import com.google.android.gms.games.snapshot.SnapshotMetadataChange;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.internal.kc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GamesClientImpl
extends d<IGamesService>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    EventIncrementManager Wh = new EventIncrementManager(){

        @Override
        public EventIncrementCache kv() {
            return new GameClientEventIncrementCache();
        }
    };
    private final String Wi;
    private final String Dd;
    private final Map<String, RealTimeSocket> Wj;
    private PlayerEntity Wk;
    private GameEntity Wl;
    private final PopupManager Wm;
    private boolean Wn = false;
    private final Binder Wo;
    private final long Wp;
    private final Games.GamesOptions Wq;

    public GamesClientImpl(Context context, Looper looper, String gamePackageName, String accountName, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView, Games.GamesOptions options) {
        super(context, looper, connectedListener, connectionFailedListener, scopes);
        this.Wi = gamePackageName;
        this.Dd = n.i(accountName);
        this.Wo = new Binder();
        this.Wj = new HashMap<String, RealTimeSocket>();
        this.Wm = PopupManager.a(this, gravity);
        this.k(gamesContentView);
        this.Wp = this.hashCode();
        this.Wq = options;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.Wn) {
            this.Wm.kJ();
            this.Wn = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.Wn = false;
    }

    public void dB(int n2) {
        this.Wm.setGravity(n2);
    }

    public void k(View view) {
        this.Wm.l(view);
    }

    @Override
    protected void c(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            n.a(!bl2, "Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty");
        } else {
            n.a(bl2, "Games APIs requires %s to function.", "https://www.googleapis.com/auth/games");
        }
    }

    @Override
    public void connect() {
        this.jW();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.Wn = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.gS();
                iGamesService.ku();
                this.Wh.flush();
                iGamesService.q(this.Wp);
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.kt();
        super.disconnect();
    }

    @Override
    protected String getStartServiceAction() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String getServiceDescriptor() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService az(IBinder iBinder) {
        return IGamesService.Stub.aB(iBinder);
    }

    @Override
    public Bundle fD() {
        try {
            Bundle bundle = ((IGamesService)this.gS()).fD();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    private void jW() {
        this.Wk = null;
    }

    @Override
    protected void a(k k2, d.e e2) throws RemoteException {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.Wq.Vs);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.Wq.Vt);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.Wq.Vu);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.Wq.Vv);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.Wq.Vw);
        bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.Wq.Vx);
        bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.Wq.Vy);
        k2.a(e2, 6111000, this.getContext().getPackageName(), this.Dd, this.gR(), this.Wi, this.Wm.kL(), string, bundle);
    }

    public String jX() {
        try {
            return ((IGamesService)this.gS()).jX();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    public String jY() {
        try {
            return ((IGamesService)this.gS()).jY();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player jZ() {
        this.dK();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Wk == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.gS()).kw());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.Wk = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.p("GamesClientImpl", "service died");
                }
            }
        }
        return this.Wk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game ka() {
        this.dK();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Wl == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.gS()).ky());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.Wl = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.release();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.p("GamesClientImpl", "service died");
                }
            }
        }
        return this.Wl;
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string, int n2, boolean bl2, boolean bl3) {
        switch (string) {
            case "played_with": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        try {
            ((IGamesService)this.gS()).d(new PlayersLoadedBinderCallback(b2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string, String string2, int n2, boolean bl2, boolean bl3) {
        switch (string) {
            case "circled": 
            case "played_with": 
            case "nearby": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid player collection: " + string);
            }
        }
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string, string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent kb() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kb();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent bu(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).bu(string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string, boolean bl2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> b2, String string, String string2, int n2, int n3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(b2), string, string2, n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), leaderboardScoreBuffer.ly().lz(), n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.SubmitScoreResult> b2, String string, long l2, String string2) {
        try {
            SubmitScoreBinderCallbacks submitScoreBinderCallbacks = b2 == null ? null : new SubmitScoreBinderCallbacks(b2);
            ((IGamesService)this.gS()).a((IGamesCallbacks)submitScoreBinderCallbacks, string, l2, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent kc() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kc();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void c(BaseImplementation.b<Achievements.LoadAchievementsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.Wm.kL(), this.Wm.kK());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string, this.Wm.kL(), this.Wm.kK());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string, n2, this.Wm.kL(), this.Wm.kK());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.UpdateAchievementResult> b2, String string, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = b2 == null ? null : new AchievementUpdatedBinderCallback(b2);
            ((IGamesService)this.gS()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string, n2, this.Wm.kL(), this.Wm.kK());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Events.LoadEventsResult> b2, boolean bl2) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).f((IGamesCallbacks)new EventsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Events.LoadEventsResult> b2, boolean bl2, String ... stringArray) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new EventsLoadedBinderCallback(b2), bl2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void n(String string, int n2) {
        this.Wh.n(string, n2);
    }

    public Intent kd() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kd();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent ke() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).ke();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(onInvitationReceivedListener);
            ((IGamesService)this.gS()).a((IGamesCallbacks)invitationReceivedBinderCallback, this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void kf() {
        try {
            ((IGamesService)this.gS()).r(this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(onTurnBasedMatchUpdateReceivedListener);
            ((IGamesService)this.gS()).b((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void kg() {
        try {
            ((IGamesService)this.gS()).s(this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(QuestUpdateListener questUpdateListener) {
        try {
            QuestUpdateBinderCallback questUpdateBinderCallback = new QuestUpdateBinderCallback(questUpdateListener);
            ((IGamesService)this.gS()).d((IGamesCallbacks)questUpdateBinderCallback, this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void kh() {
        try {
            ((IGamesService)this.gS()).u(this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(OnRequestReceivedListener onRequestReceivedListener) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(onRequestReceivedListener);
            ((IGamesService)this.gS()).c((IGamesCallbacks)requestReceivedBinderCallback, this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void ki() {
        try {
            ((IGamesService)this.gS()).t(this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent kj() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kj();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(Room room, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a((RoomEntity)room.freeze(), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent kk() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).kk();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void f(BaseImplementation.b<GamesMetadata.LoadGamesResult> b2) {
        try {
            ((IGamesService)this.gS()).d(new GamesLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Status> b2) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).a(new SignOutCompleteBinderCallbacks(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int kl() {
        int n2 = 4368;
        try {
            n2 = ((IGamesService)this.gS()).kl();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String km() {
        try {
            return ((IGamesService)this.gS()).km();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return null;
        }
    }

    public void c(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, int n2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new InvitationsLoadedBinderCallback(b2), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void o(String string, int n2) {
        try {
            ((IGamesService)this.gS()).o(string, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void p(String string, int n2) {
        try {
            ((IGamesService)this.gS()).p(string, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent a(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.lF(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).l(new TurnBasedMatchInitiatedBinderCallbacks(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).m(new TurnBasedMatchInitiatedBinderCallbacks(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int kn() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).kn();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> b2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(b2), string, byArray, string2, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> b2, String string, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(b2), string, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).o(new TurnBasedMatchLeftBinderCallbacks(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> b2, String string, String string2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(b2), string, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).n(new TurnBasedMatchCanceledBinderCallbacks(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void bv(String string) {
        try {
            ((IGamesService)this.gS()).bG(string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> b2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(b2), n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).p(new TurnBasedMatchLoadedBinderCallbacks(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent b(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).b(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(RoomConfig roomConfig) {
        this.kt();
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.gS()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Wo, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), roomConfig.isSocketEnabled(), this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(RoomConfig roomConfig) {
        this.kt();
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.gS()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.Wo, roomConfig.getInvitationId(), roomConfig.isSocketEnabled(), this.Wp);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(RoomUpdateListener roomUpdateListener, String string) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new RoomBinderCallbacks(roomUpdateListener), string);
            this.kt();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, byte[] byArray, String string, String string2) {
        try {
            return ((IGamesService)this.gS()).a((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(reliableMessageSentCallback), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string, String[] stringArray) {
        n.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.gS()).b(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int d(byte[] byArray, String string) {
        try {
            return ((IGamesService)this.gS()).b(byArray, string, null);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket t(String string, String string2) {
        if (string2 == null || !ParticipantUtils.bS(string2)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.Wj.get(string2);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.bw(string2);
        }
        return realTimeSocket;
    }

    private RealTimeSocket bw(String string) {
        RealTimeSocket realTimeSocket = kc.hD() ? this.by(string) : this.bx(string);
        if (realTimeSocket != null) {
            this.Wj.put(string, realTimeSocket);
        }
        return realTimeSocket;
    }

    private RealTimeSocket bx(String string) {
        try {
            String string2 = ((IGamesService)this.gS()).bC(string);
            if (string2 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            localSocket.connect(new LocalSocketAddress(string2));
            return new RealTimeSocketImpl(localSocket, string);
        }
        catch (RemoteException remoteException) {
            GamesLog.q("GamesClientImpl", "Unable to create socket. Service died.");
        }
        catch (IOException iOException) {
            GamesLog.q("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
        }
        return null;
    }

    private RealTimeSocket by(String string) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ((IGamesService)this.gS()).bH(string);
            if (parcelFileDescriptor != null) {
                GamesLog.o("GamesClientImpl", "Created native libjingle socket.");
                return new LibjingleNativeSocket(parcelFileDescriptor);
            }
            GamesLog.q("GamesClientImpl", "Unable to create socket for " + string);
            return null;
        }
        catch (RemoteException remoteException) {
            GamesLog.q("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void dC(int n2) {
        try {
            ((IGamesService)this.gS()).dC(n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent ko() {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).ko();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(int n2, byte[] byArray, int n3, Bitmap bitmap, String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a(n2, byArray, n3, string);
            n.b(bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int kp() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).kp();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int kq() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).kq();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void b(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.LoadRequestsResult> b2, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(b2), n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public Intent b(int[] nArray) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).b(nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent bz(String string) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).bz(string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void i(BaseImplementation.b<Quests.AcceptQuestResult> b2, String string) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).u(new QuestAcceptedBinderCallbacks(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Quests.ClaimMilestoneResult> b2, String string, String string2) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).f(new QuestMilestoneClaimBinderCallbacks(b2, string2), string, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, int[] nArray, int n2, boolean bl2) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Quests.LoadQuestsResult> b2, boolean bl2, String[] stringArray) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void bA(String string) {
        try {
            ((IGamesService)this.gS()).a(string, this.Wm.kL(), this.Wm.kK());
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, String string, String string2, int[] nArray, int n2, boolean bl2) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), string, string2, nArray, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Quests.LoadQuestsResult> b2, String string, String string2, boolean bl2, String[] stringArray) {
        try {
            this.Wh.flush();
            ((IGamesService)this.gS()).a((IGamesCallbacks)new QuestsLoadedBinderCallbacks(b2), string, string2, stringArray, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public int kr() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).kr();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int ks() {
        int n2 = -1;
        try {
            n2 = ((IGamesService)this.gS()).ks();
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
        return n2;
    }

    public Intent a(String string, boolean bl2, boolean bl3, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.gS()).a(string, bl2, bl3, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void e(BaseImplementation.b<Snapshots.LoadSnapshotsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).d((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Snapshots.OpenSnapshotResult> b2, String string, boolean bl2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(b2), string, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Snapshots.CommitSnapshotResult> b2, Snapshot snapshot, SnapshotMetadataChange snapshotMetadataChange) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        n.a(!snapshotContents.isClosed(), "Snapshot already closed");
        a a2 = snapshotMetadataChange.lK();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.getContents();
        snapshotContents.close();
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new SnapshotCommittedBinderCallbacks(b2), snapshot.getMetadata().getSnapshotId(), snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(Snapshot snapshot) {
        SnapshotContents snapshotContents = snapshot.getSnapshotContents();
        n.a(!snapshotContents.isClosed(), "Snapshot already closed");
        Contents contents = snapshotContents.getContents();
        snapshotContents.close();
        try {
            ((IGamesService)this.gS()).a(contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void j(BaseImplementation.b<Snapshots.DeleteSnapshotResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).r(new SnapshotDeletedBinderCallbacks(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Snapshots.OpenSnapshotResult> b2, String string, String string2, SnapshotMetadataChange snapshotMetadataChange, SnapshotContents snapshotContents) {
        n.a(!snapshotContents.isClosed(), "SnapshotContents already closed");
        a a2 = snapshotMetadataChange.lK();
        if (a2 != null) {
            a2.a(this.getContext().getCacheDir());
        }
        Contents contents = snapshotContents.getContents();
        snapshotContents.close();
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new SnapshotOpenedBinderCallbacks(b2), string, string2, snapshotMetadataChange, contents);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void k(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void l(BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).f((IGamesCallbacks)new GameInstancesLoadedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, int n2, int n3, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), n2, n3, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(b2), string, n2, bl2, bl3, bl4, bl5);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).e(new ExtendedGamesLoadedBinderCallback(b2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).f(new ExtendedGamesLoadedBinderCallback(b2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> b2, String string, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).c(new ExtendedGamesLoadedBinderCallback(b2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void m(BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).q(new GameSearchSuggestionsLoadedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string, boolean bl2) {
        try {
            ((IGamesService)this.gS()).d((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> b2, String string, String string2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(b2), string, string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(b2), string, string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Leaderboards.LoadScoresResult> b2, String string, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.gS()).b(new LeaderboardScoresLoadedBinderCallback(b2), string, string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).e(new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Players.LoadPlayersResult> b2, String string, int n2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Players.LoadPlayersResult> b2, String string, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<Players.LoadPlayersResult> b2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).d(new PlayersLoadedBinderCallback(b2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Players.LoadPlayersResult> b2, String string, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(b2), string, null, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> b2) {
        try {
            ((IGamesService)this.gS()).j(new OwnerCoverPhotoUrisLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void n(BaseImplementation.b<Players.LoadXpForGameCategoriesResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).s(new PlayerXpForGameCategoriesLoadedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Players.LoadXpStreamResult> b2, String string, int n2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(b2), string, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Players.LoadXpStreamResult> b2, String string, int n2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new PlayerXpStreamLoadedBinderCallback(b2), string, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Players.LoadProfileSettingsResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).g((IGamesCallbacks)new ProfileSettingsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void g(BaseImplementation.b<Status> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).h((IGamesCallbacks)new ProfileSettingsUpdatedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void b(BaseImplementation.b<Achievements.LoadAchievementsResult> b2, String string, String string2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(b2), string, string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string, String string2) {
        try {
            ((IGamesService)this.gS()).d((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), string, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> b2, String string, String string2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(b2), string, string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void e(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, String string, int n2) {
        try {
            ((IGamesService)this.gS()).b((IGamesCallbacks)new InvitationsLoadedBinderCallback(b2), string, n2, false);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void o(BaseImplementation.b<Invitations.LoadInvitationsResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).k(new InvitationsLoadedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> b2, String string, int n2, int[] nArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(b2), string, n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<Acls.LoadAclResult> b2) {
        try {
            ((IGamesService)this.gS()).h(new NotifyAclLoadedBinderCallback(b2));
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void p(BaseImplementation.b<Status> b2, String string) {
        try {
            ((IGamesService)this.gS()).j(new NotifyAclUpdatedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void d(BaseImplementation.b<Notifications.GameMuteStatusChangeResult> b2, String string, boolean bl2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(b2), string, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void q(BaseImplementation.b<Notifications.GameMuteStatusLoadResult> b2, String string) {
        try {
            ((IGamesService)this.gS()).i(new GameMuteStatusLoadedBinderCallback(b2), string);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    @Deprecated
    public void i(BaseImplementation.b<Notifications.ContactSettingLoadResult> b2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(b2), false);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void h(BaseImplementation.b<Notifications.ContactSettingLoadResult> b2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).e((IGamesCallbacks)new ContactSettingsLoadedBinderCallback(b2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Status> b2, boolean bl2, Bundle bundle) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(b2), bl2, bundle);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void j(BaseImplementation.b<Notifications.InboxCountResult> b2) {
        try {
            ((IGamesService)this.gS()).t(new InboxCountsLoadedBinderCallback(b2), null);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.SendRequestResult> b2, String string, String[] stringArray, int n2, byte[] byArray, int n3) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestSentBinderCallbacks(b2), string, stringArray, n2, byArray, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.UpdateRequestsResult> b2, String string, String string2, String[] stringArray) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(b2), string, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void a(BaseImplementation.b<Requests.LoadRequestsResult> b2, String string, String string2, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(b2), string, string2, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void f(BaseImplementation.b<Requests.LoadRequestSummariesResult> b2, String string, int n2) {
        try {
            ((IGamesService)this.gS()).a((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(b2), string, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    public void c(BaseImplementation.b<Snapshots.LoadSnapshotsResult> b2, String string, String string2, boolean bl2) {
        try {
            ((IGamesService)this.gS()).c((IGamesCallbacks)new SnapshotsLoadedBinderCallbacks(b2), string, string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.p("GamesClientImpl", "service died");
        }
    }

    private void kt() {
        for (RealTimeSocket realTimeSocket : this.Wj.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                GamesLog.c("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.Wj.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.gS()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "service died");
            }
        }
    }

    public void ku() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.gS()).ku();
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room R(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.release();
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.Wn = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface j(IBinder iBinder) {
        return this.az(iBinder);
    }

    private static final class DeleteSnapshotResultImpl
    implements Snapshots.DeleteSnapshotResult {
        private final Status CM;
        private final String Wx;

        DeleteSnapshotResultImpl(int statusCode, String snapshotId) {
            this.CM = new Status(statusCode);
            this.Wx = snapshotId;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public String getSnapshotId() {
            return this.Wx;
        }
    }

    private static final class CommitSnapshotResultImpl
    extends com.google.android.gms.common.api.a
    implements Snapshots.CommitSnapshotResult {
        private final SnapshotMetadata Ww;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CommitSnapshotResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(dataHolder);
            try {
                this.Ww = snapshotMetadataBuffer.getCount() > 0 ? new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0)) : null;
            }
            finally {
                snapshotMetadataBuffer.release();
            }
        }

        @Override
        public SnapshotMetadata getSnapshotMetadata() {
            return this.Ww;
        }
    }

    private static final class OpenSnapshotResultImpl
    extends com.google.android.gms.common.api.a
    implements Snapshots.OpenSnapshotResult {
        private final Snapshot Xb;
        private final String Xc;
        private final Snapshot Xd;
        private final Contents Xe;
        private final SnapshotContents Xf;

        OpenSnapshotResultImpl(DataHolder dataHolder, Contents currentContents) {
            this(dataHolder, null, currentContents, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OpenSnapshotResultImpl(DataHolder metadataHolder, String conflictId, Contents currentContents, Contents conflictContents, Contents resolutionContents) {
            super(metadataHolder);
            SnapshotMetadataBuffer snapshotMetadataBuffer = new SnapshotMetadataBuffer(metadataHolder);
            try {
                if (snapshotMetadataBuffer.getCount() == 0) {
                    this.Xb = null;
                    this.Xd = null;
                } else if (snapshotMetadataBuffer.getCount() == 1) {
                    com.google.android.gms.common.internal.a.I(metadataHolder.getStatusCode() != 4004);
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Xb = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContents(currentContents));
                    this.Xd = null;
                } else {
                    SnapshotMetadataEntity snapshotMetadataEntity = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(0));
                    this.Xb = new SnapshotEntity(snapshotMetadataEntity, new SnapshotContents(currentContents));
                    SnapshotMetadataEntity snapshotMetadataEntity2 = new SnapshotMetadataEntity(snapshotMetadataBuffer.get(1));
                    this.Xd = new SnapshotEntity(snapshotMetadataEntity2, new SnapshotContents(conflictContents));
                }
            }
            finally {
                snapshotMetadataBuffer.release();
            }
            this.Xc = conflictId;
            this.Xe = resolutionContents;
            this.Xf = new SnapshotContents(resolutionContents);
        }

        @Override
        public Snapshot getSnapshot() {
            return this.Xb;
        }

        @Override
        public String getConflictId() {
            return this.Xc;
        }

        @Override
        public Snapshot getConflictingSnapshot() {
            return this.Xd;
        }

        @Override
        @Deprecated
        public Contents getResolutionContents() {
            return this.Xe;
        }

        @Override
        public SnapshotContents getResolutionSnapshotContents() {
            return this.Xf;
        }
    }

    private static final class LoadSnapshotsResultImpl
    extends com.google.android.gms.common.api.a
    implements Snapshots.LoadSnapshotsResult {
        LoadSnapshotsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }

        @Override
        public SnapshotMetadataBuffer getSnapshots() {
            return new SnapshotMetadataBuffer(this.IC);
        }
    }

    private static final class LoadQuestsResultImpl
    extends com.google.android.gms.common.api.a
    implements Quests.LoadQuestsResult {
        private final DataHolder IC;

        LoadQuestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.IC = dataHolder;
        }

        @Override
        public QuestBuffer getQuests() {
            return new QuestBuffer(this.IC);
        }
    }

    private static final class ClaimMilestoneResultImpl
    extends com.google.android.gms.common.api.a
    implements Quests.ClaimMilestoneResult {
        private final Milestone Wv;
        private final Quest Wt;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClaimMilestoneResultImpl(DataHolder dataHolder, String milestoneId) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                if (questBuffer.getCount() > 0) {
                    this.Wt = new QuestEntity((Quest)questBuffer.get(0));
                    List<Milestone> list = this.Wt.lH();
                    int n2 = list.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!list.get(i2).getMilestoneId().equals(milestoneId)) continue;
                        this.Wv = list.get(i2);
                        return;
                    }
                    this.Wv = null;
                } else {
                    this.Wv = null;
                    this.Wt = null;
                }
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Milestone getMilestone() {
            return this.Wv;
        }

        @Override
        public Quest getQuest() {
            return this.Wt;
        }
    }

    private static final class AcceptQuestResultImpl
    extends com.google.android.gms.common.api.a
    implements Quests.AcceptQuestResult {
        private final Quest Wt;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AcceptQuestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            try {
                this.Wt = questBuffer.getCount() > 0 ? new QuestEntity((Quest)questBuffer.get(0)) : null;
            }
            finally {
                questBuffer.release();
            }
        }

        @Override
        public Quest getQuest() {
            return this.Wt;
        }
    }

    private static final class LoadRequestSummariesResultImpl
    extends com.google.android.gms.common.api.a
    implements Requests.LoadRequestSummariesResult {
        LoadRequestSummariesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadRequestsResultImpl
    implements Requests.LoadRequestsResult {
        private final Status CM;
        private final Bundle WQ;

        LoadRequestsResultImpl(Status status, Bundle requestData) {
            this.CM = status;
            this.WQ = requestData;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string = RequestType.dH(requestType);
            if (!this.WQ.containsKey(string)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.WQ.get(string);
            return new GameRequestBuffer(dataHolder);
        }

        @Override
        public void release() {
            for (String string : this.WQ.keySet()) {
                DataHolder dataHolder = (DataHolder)this.WQ.getParcelable(string);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }
    }

    private static final class UpdateRequestsResultImpl
    extends com.google.android.gms.common.api.a
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes XJ;

        UpdateRequestsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.XJ = RequestUpdateOutcomes.V(dataHolder);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.XJ.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.XJ.getRequestIds();
        }
    }

    private static final class SendRequestResultImpl
    extends com.google.android.gms.common.api.a
    implements Requests.SendRequestResult {
        private final GameRequest Xq;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SendRequestResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.Xq = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.release();
            }
        }
    }

    private static final class InboxCountResultImpl
    implements Notifications.InboxCountResult {
        private final Status CM;
        private final Bundle WA;

        InboxCountResultImpl(Status status, Bundle inboxCounts) {
            this.CM = status;
            this.WA = inboxCounts;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class ContactSettingLoadResultImpl
    extends com.google.android.gms.common.api.a
    implements Notifications.ContactSettingLoadResult {
        ContactSettingLoadResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class GameMuteStatusLoadResultImpl
    implements Notifications.GameMuteStatusLoadResult {
        private final Status CM;
        private final String Wy;
        private final boolean Wz;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadResultImpl(DataHolder dataHolder) {
            try {
                this.CM = new Status(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.Wy = dataHolder.c("external_game_id", 0, 0);
                    this.Wz = dataHolder.d("muted", 0, 0);
                } else {
                    this.Wy = null;
                    this.Wz = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class GameMuteStatusChangeResultImpl
    implements Notifications.GameMuteStatusChangeResult {
        private final Status CM;
        private final String Wy;
        private final boolean Wz;

        public GameMuteStatusChangeResultImpl(int statusCode, String externalGameId, boolean isMuted) {
            this.CM = new Status(statusCode);
            this.Wy = externalGameId;
            this.Wz = isMuted;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class LoadAclResultImpl
    extends com.google.android.gms.common.api.a
    implements Acls.LoadAclResult {
        LoadAclResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class CancelMatchResultImpl
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status CM;
        private final String Wu;

        CancelMatchResultImpl(Status status, String externalMatchId) {
            this.CM = status;
            this.Wu = externalMatchId;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public String getMatchId() {
            return this.Wu;
        }
    }

    private static final class LeaveMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LeaveMatchResult {
        LeaveMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class UpdateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.UpdateMatchResult {
        UpdateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class InitiateMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.InitiateMatchResult {
        InitiateMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static final class LoadMatchResultImpl
    extends TurnBasedMatchResult
    implements TurnBasedMultiplayer.LoadMatchResult {
        LoadMatchResultImpl(DataHolder dataHolder) {
            super(dataHolder);
        }
    }

    private static abstract class TurnBasedMatchResult
    extends com.google.android.gms.common.api.a {
        final TurnBasedMatch WY;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchResult(DataHolder dataHolder) {
            super(dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.WY = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.release();
            }
        }

        public TurnBasedMatch getMatch() {
            return this.WY;
        }
    }

    private static final class SubmitScoreResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData XC;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                this.XC = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.XC;
        }
    }

    private static final class LoadOwnerCoverPhotoUrisResultImpl
    implements Players.LoadOwnerCoverPhotoUrisResult {
        private final Status CM;
        private final Bundle MZ;

        LoadOwnerCoverPhotoUrisResultImpl(int statusCode, Bundle bundle) {
            this.CM = new Status(statusCode);
            this.MZ = bundle;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class LoadProfileSettingsResultImpl
    extends com.google.android.gms.common.api.a
    implements Players.LoadProfileSettingsResult {
        private final boolean We;
        private final boolean WP;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadProfileSettingsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            try {
                if (dataHolder.getCount() > 0) {
                    int n2 = dataHolder.ar(0);
                    this.We = dataHolder.d("profile_visible", 0, n2);
                    this.WP = dataHolder.d("profile_visibility_explicitly_set", 0, n2);
                } else {
                    this.We = true;
                    this.WP = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public boolean isProfileVisible() {
            return this.We;
        }

        @Override
        public boolean isVisibilityExplicitlySet() {
            return this.WP;
        }
    }

    private static final class LoadXpStreamResultImpl
    extends com.google.android.gms.common.api.a
    implements Players.LoadXpStreamResult {
        private final ExperienceEventBuffer WV;

        LoadXpStreamResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WV = new ExperienceEventBuffer(dataHolder);
        }
    }

    private static final class LoadXpForGameCategoriesResultImpl
    implements Players.LoadXpForGameCategoriesResult {
        private final Status CM;
        private final List<String> WT;
        private final Bundle WU;

        LoadXpForGameCategoriesResultImpl(Status status, Bundle xpData) {
            this.CM = status;
            this.WT = xpData.getStringArrayList("game_category_list");
            this.WU = xpData;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }
    }

    private static final class LoadPlayersResultImpl
    extends com.google.android.gms.common.api.a
    implements Players.LoadPlayersResult {
        private final PlayerBuffer WO;

        LoadPlayersResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WO = new PlayerBuffer(dataHolder);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.WO;
        }
    }

    private static final class LoadMatchesResultImpl
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status CM;
        private final LoadMatchesResponse WM;

        LoadMatchesResultImpl(Status status, Bundle matchData) {
            this.CM = status;
            this.WM = new LoadMatchesResponse(matchData);
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.WM;
        }

        @Override
        public void release() {
            this.WM.close();
        }
    }

    private static final class LoadInvitationsResultImpl
    extends com.google.android.gms.common.api.a
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer WL;

        LoadInvitationsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WL = new InvitationBuffer(dataHolder);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.WL;
        }
    }

    private static final class LoadPlayerScoreResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.LoadPlayerScoreResult {
        private final LeaderboardScoreEntity WN;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadPlayerScoreResultImpl(DataHolder scoreHolder) {
            super(scoreHolder);
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.WN = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.release();
            }
        }

        @Override
        public LeaderboardScore getScore() {
            return this.WN;
        }
    }

    private static final class LoadScoresResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity WR;
        private final LeaderboardScoreBuffer WS;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LoadScoresResultImpl(DataHolder leaderboard, DataHolder scores) {
            super(scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.WR = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.release();
            }
            this.WS = new LeaderboardScoreBuffer(scores);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.WR;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.WS;
        }
    }

    private static final class LeaderboardMetadataResultImpl
    extends com.google.android.gms.common.api.a
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer WE;

        LeaderboardMetadataResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WE = new LeaderboardBuffer(dataHolder);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.WE;
        }
    }

    private static final class LoadGameSearchSuggestionsResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        LoadGameSearchSuggestionsResultImpl(DataHolder data) {
            super(data);
        }
    }

    private static final class LoadGameInstancesResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer WJ;

        LoadGameInstancesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WJ = new GameInstanceBuffer(dataHolder);
        }
    }

    private static final class LoadExtendedGamesResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadExtendedGamesResult {
        private final ExtendedGameBuffer WI;

        LoadExtendedGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WI = new ExtendedGameBuffer(dataHolder);
        }
    }

    private static final class LoadGamesResultImpl
    extends com.google.android.gms.common.api.a
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer WK;

        LoadGamesResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WK = new GameBuffer(dataHolder);
        }

        @Override
        public GameBuffer getGames() {
            return this.WK;
        }
    }

    private static final class LoadEventResultImpl
    extends com.google.android.gms.common.api.a
    implements Events.LoadEventsResult {
        private final EventBuffer WH;

        LoadEventResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WH = new EventBuffer(dataHolder);
        }

        @Override
        public EventBuffer getEvents() {
            return this.WH;
        }
    }

    private static final class UpdateAchievementResultImpl
    implements Achievements.UpdateAchievementResult {
        private final Status CM;
        private final String VP;

        UpdateAchievementResultImpl(int statusCode, String achievementId) {
            this.CM = new Status(statusCode);
            this.VP = achievementId;
        }

        @Override
        public Status getStatus() {
            return this.CM;
        }

        @Override
        public String getAchievementId() {
            return this.VP;
        }
    }

    private static final class LoadAchievementsResultImpl
    extends com.google.android.gms.common.api.a
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer WG;

        LoadAchievementsResultImpl(DataHolder dataHolder) {
            super(dataHolder);
            this.WG = new AchievementBuffer(dataHolder);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.WG;
        }
    }

    private final class RealTimeMessageSentCallback
    extends d.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int HF;
        private final String Xm;
        private final int Xn;

        RealTimeMessageSentCallback(RealTimeMultiplayer.ReliableMessageSentCallback listener, int statusCode, int token, String recipientParticipantId) {
            super(GamesClientImpl.this, listener);
            this.HF = statusCode;
            this.Xn = token;
            this.Xm = recipientParticipantId;
        }

        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.HF, this.Xn, this.Xm);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    private final class MessageReceivedCallback
    extends d.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage WZ;

        MessageReceivedCallback(RealTimeMessageReceivedListener listener, RealTimeMessage message) {
            super(GamesClientImpl.this, listener);
            this.WZ = message;
        }

        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.WZ);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RealTimeMessageReceivedListener)object);
        }
    }

    private final class P2PDisconnectedCallback
    extends d.b<RoomStatusUpdateListener> {
        private final String Xg;

        P2PDisconnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(GamesClientImpl.this, listener);
            this.Xg = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.Xg);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class P2PConnectedCallback
    extends d.b<RoomStatusUpdateListener> {
        private final String Xg;

        P2PConnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(GamesClientImpl.this, listener);
            this.Xg = participantId;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.Xg);
            }
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    private final class PeerDisconnectedCallback
    extends AbstractPeerStatusCallback {
        PeerDisconnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    private final class PeerConnectedCallback
    extends AbstractPeerStatusCallback {
        PeerConnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    private final class PeerDeclinedCallback
    extends AbstractPeerStatusCallback {
        PeerDeclinedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    private final class PeerLeftRoomCallback
    extends AbstractPeerStatusCallback {
        PeerLeftRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    private final class PeerJoinedRoomCallback
    extends AbstractPeerStatusCallback {
        PeerJoinedRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    private final class PeerInvitedToRoomCallback
    extends AbstractPeerStatusCallback {
        PeerInvitedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    private final class DisconnectedFromRoomCallback
    extends AbstractRoomStatusCallback {
        DisconnectedFromRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    private final class ConnectedToRoomCallback
    extends AbstractRoomStatusCallback {
        ConnectedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    private final class RoomAutoMatchingCallback
    extends AbstractRoomStatusCallback {
        RoomAutoMatchingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    private final class RoomConnectingCallback
    extends AbstractRoomStatusCallback {
        RoomConnectingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    private final class RoomConnectedCallback
    extends AbstractRoomCallback {
        RoomConnectedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    private final class LeftRoomCallback
    extends d.b<RoomUpdateListener> {
        private final int HF;
        private final String WF;

        LeftRoomCallback(RoomUpdateListener listener, int statusCode, String roomId) {
            super(GamesClientImpl.this, listener);
            this.HF = statusCode;
            this.WF = roomId;
        }

        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.HF, this.WF);
        }

        @Override
        protected void gT() {
        }

        @Override
        public /* synthetic */ void g(Object object) {
            this.a((RoomUpdateListener)object);
        }
    }

    private final class JoinedRoomCallback
    extends AbstractRoomCallback {
        public JoinedRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    private final class RoomCreatedCallback
    extends AbstractRoomCallback {
        public RoomCreatedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    private abstract class AbstractPeerStatusCallback
    extends AbstractRoomStatusCallback {
        private final ArrayList<String> Ws;

        AbstractPeerStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder);
            this.Ws = new ArrayList();
            int n2 = participantIds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Ws.add(participantIds[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.Ws);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    private abstract class AbstractRoomStatusCallback
    extends d.d<RoomStatusUpdateListener> {
        AbstractRoomStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(GamesClientImpl.this, listener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, GamesClientImpl.this.R(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    private abstract class AbstractRoomCallback
    extends d.d<RoomUpdateListener> {
        AbstractRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(GamesClientImpl.this, listener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, GamesClientImpl.this.R(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    private final class NearbyPlayerDetectedCallback
    extends d.b<OnNearbyPlayerDetectedListener> {
        private final Player Xa;

        protected void a(OnNearbyPlayerDetectedListener onNearbyPlayerDetectedListener) {
            onNearbyPlayerDetectedListener.a(this.Xa);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.a((OnNearbyPlayerDetectedListener)object);
        }
    }

    private final class RequestRemovedCallback
    extends d.b<OnRequestReceivedListener> {
        private final String Xr;

        RequestRemovedCallback(OnRequestReceivedListener listener, String requestId) {
            super(GamesClientImpl.this, listener);
            this.Xr = requestId;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.Xr);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class RequestReceivedCallback
    extends d.b<OnRequestReceivedListener> {
        private final GameRequest Xq;

        RequestReceivedCallback(OnRequestReceivedListener listener, GameRequest request) {
            super(GamesClientImpl.this, listener);
            this.Xq = request;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.Xq);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    private final class QuestCompletedCallback
    extends d.b<QuestUpdateListener> {
        private final Quest Wt;

        QuestCompletedCallback(QuestUpdateListener listener, Quest quest) {
            super(GamesClientImpl.this, listener);
            this.Wt = quest;
        }

        protected void b(QuestUpdateListener questUpdateListener) {
            questUpdateListener.onQuestCompleted(this.Wt);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((QuestUpdateListener)object);
        }
    }

    private final class MatchRemovedCallback
    extends d.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String WW;

        MatchRemovedCallback(OnTurnBasedMatchUpdateReceivedListener listener, String matchId) {
            super(GamesClientImpl.this, listener);
            this.WW = matchId;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.WW);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class MatchUpdateReceivedCallback
    extends d.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch WY;

        MatchUpdateReceivedCallback(OnTurnBasedMatchUpdateReceivedListener listener, TurnBasedMatch match) {
            super(GamesClientImpl.this, listener);
            this.WY = match;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.WY);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    private final class InvitationRemovedCallback
    extends d.b<OnInvitationReceivedListener> {
        private final String WD;

        InvitationRemovedCallback(OnInvitationReceivedListener listener, String invitationId) {
            super(GamesClientImpl.this, listener);
            this.WD = invitationId;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.WD);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    private final class InvitationReceivedCallback
    extends d.b<OnInvitationReceivedListener> {
        private final Invitation WC;

        InvitationReceivedCallback(OnInvitationReceivedListener listener, Invitation invitation) {
            super(GamesClientImpl.this, listener);
            this.WC = invitation;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.WC);
        }

        @Override
        protected void gT() {
        }

        @Override
        protected /* synthetic */ void g(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    final class SnapshotDeletedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.DeleteSnapshotResult> De;

        public SnapshotDeletedBinderCallbacks(BaseImplementation.b<Snapshots.DeleteSnapshotResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void i(int n2, String string) {
            this.De.b(new DeleteSnapshotResultImpl(n2, string));
        }
    }

    private final class SnapshotCommittedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.CommitSnapshotResult> Xz;

        public SnapshotCommittedBinderCallbacks(BaseImplementation.b<Snapshots.CommitSnapshotResult> resultHolder) {
            this.Xz = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void J(DataHolder dataHolder) {
            this.Xz.b(new CommitSnapshotResultImpl(dataHolder));
        }
    }

    private final class SnapshotOpenedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.OpenSnapshotResult> XA;

        public SnapshotOpenedBinderCallbacks(BaseImplementation.b<Snapshots.OpenSnapshotResult> resultHolder) {
            this.XA = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, Contents contents) {
            this.XA.b(new OpenSnapshotResultImpl(dataHolder, contents));
        }

        @Override
        public void a(DataHolder dataHolder, String string, Contents contents, Contents contents2, Contents contents3) {
            this.XA.b(new OpenSnapshotResultImpl(dataHolder, string, contents, contents2, contents3));
        }
    }

    private final class SnapshotsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Snapshots.LoadSnapshotsResult> XB;

        public SnapshotsLoadedBinderCallbacks(BaseImplementation.b<Snapshots.LoadSnapshotsResult> resultHolder) {
            this.XB = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void I(DataHolder dataHolder) {
            this.XB.b(new LoadSnapshotsResultImpl(dataHolder));
        }
    }

    private final class QuestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.LoadQuestsResult> Xl;

        public QuestsLoadedBinderCallbacks(BaseImplementation.b<Quests.LoadQuestsResult> resultHolder) {
            this.Xl = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void O(DataHolder dataHolder) {
            this.Xl.b(new LoadQuestsResultImpl(dataHolder));
        }
    }

    private final class QuestMilestoneClaimBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.ClaimMilestoneResult> Xi;
        private final String Xj;

        public QuestMilestoneClaimBinderCallbacks(BaseImplementation.b<Quests.ClaimMilestoneResult> resultHolder, String milestoneId) {
            this.Xi = n.b(resultHolder, (Object)"Holder must not be null");
            this.Xj = n.b(milestoneId, (Object)"MilestoneId must not be null");
        }

        @Override
        public void K(DataHolder dataHolder) {
            this.Xi.b(new ClaimMilestoneResultImpl(dataHolder, this.Xj));
        }
    }

    private final class QuestAcceptedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Quests.AcceptQuestResult> Xh;

        public QuestAcceptedBinderCallbacks(BaseImplementation.b<Quests.AcceptQuestResult> resultHolder) {
            this.Xh = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void L(DataHolder dataHolder) {
            this.Xh.b(new AcceptQuestResultImpl(dataHolder));
        }
    }

    private final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.LoadRequestSummariesResult> Xt;

        public RequestSummariesLoadedBinderCallbacks(BaseImplementation.b<Requests.LoadRequestSummariesResult> resultHolder) {
            this.Xt = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void H(DataHolder dataHolder) {
            this.Xt.b(new LoadRequestSummariesResultImpl(dataHolder));
        }
    }

    private final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.LoadRequestsResult> Xu;

        public RequestsLoadedBinderCallbacks(BaseImplementation.b<Requests.LoadRequestsResult> resultHolder) {
            this.Xu = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.Xu.b(new LoadRequestsResultImpl(status, bundle));
        }
    }

    private final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.SendRequestResult> Xs;

        public RequestSentBinderCallbacks(BaseImplementation.b<Requests.SendRequestResult> resultHolder) {
            this.Xs = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void G(DataHolder dataHolder) {
            this.Xs.b(new SendRequestResultImpl(dataHolder));
        }
    }

    private final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Requests.UpdateRequestsResult> Xv;

        public RequestsUpdatedBinderCallbacks(BaseImplementation.b<Requests.UpdateRequestsResult> resultHolder) {
            this.Xv = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void F(DataHolder dataHolder) {
            this.Xv.b(new UpdateRequestsResultImpl(dataHolder));
        }
    }

    private final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        public SignOutCompleteBinderCallbacks(BaseImplementation.b<Status> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void fq() {
            Status status = new Status(0);
            this.De.b(status);
        }
    }

    private final class InboxCountsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.InboxCountResult> De;

        InboxCountsLoadedBinderCallback(BaseImplementation.b<Notifications.InboxCountResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.De.b(new InboxCountResultImpl(status, bundle));
        }
    }

    private final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        ContactSettingsUpdatedBinderCallback(BaseImplementation.b<Status> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void dy(int n2) {
            this.De.b(new Status(n2));
        }
    }

    private final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.ContactSettingLoadResult> De;

        ContactSettingsLoadedBinderCallback(BaseImplementation.b<Notifications.ContactSettingLoadResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            this.De.b(new ContactSettingLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.GameMuteStatusLoadResult> De;

        GameMuteStatusLoadedBinderCallback(BaseImplementation.b<Notifications.GameMuteStatusLoadResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void B(DataHolder dataHolder) {
            this.De.b(new GameMuteStatusLoadResultImpl(dataHolder));
        }
    }

    private final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Notifications.GameMuteStatusChangeResult> De;

        GameMuteStatusChangedBinderCallback(BaseImplementation.b<Notifications.GameMuteStatusChangeResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, String string, boolean bl2) {
            this.De.b(new GameMuteStatusChangeResultImpl(n2, string, bl2));
        }
    }

    private final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        NotifyAclUpdatedBinderCallback(BaseImplementation.b<Status> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void dx(int n2) {
            this.De.b(new Status(n2));
        }
    }

    private final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Acls.LoadAclResult> De;

        NotifyAclLoadedBinderCallback(BaseImplementation.b<Acls.LoadAclResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            this.De.b(new LoadAclResultImpl(dataHolder));
        }
    }

    private final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final RealTimeMultiplayer.ReliableMessageSentCallback Xo;

        public RealTimeReliableMessageBinderCallbacks(RealTimeMultiplayer.ReliableMessageSentCallback messageSentCallbacks) {
            this.Xo = messageSentCallbacks;
        }

        @Override
        public void b(int n2, int n3, String string) {
            GamesClientImpl.this.a(new RealTimeMessageSentCallback(this.Xo, n2, n3, string));
        }
    }

    private final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final RoomUpdateListener Xw;
        private final RoomStatusUpdateListener Xx;
        private final RealTimeMessageReceivedListener Xy;

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks) {
            this.Xw = n.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.Xx = null;
            this.Xy = null;
        }

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks, RoomStatusUpdateListener roomStatusCallbacks, RealTimeMessageReceivedListener realTimeMessageReceivedCallbacks) {
            this.Xw = n.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.Xx = roomStatusCallbacks;
            this.Xy = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void u(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomCreatedCallback(this.Xw, dataHolder));
        }

        @Override
        public void v(DataHolder dataHolder) {
            GamesClientImpl.this.a(new JoinedRoomCallback(this.Xw, dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            GamesClientImpl.this.a(new LeftRoomCallback(this.Xw, statusCode, externalRoomId));
        }

        @Override
        public void y(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectedCallback(this.Xw, dataHolder));
        }

        @Override
        public void w(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectingCallback(this.Xx, dataHolder));
        }

        @Override
        public void x(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomAutoMatchingCallback(this.Xx, dataHolder));
        }

        @Override
        public void z(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ConnectedToRoomCallback(this.Xx, dataHolder));
        }

        @Override
        public void A(DataHolder dataHolder) {
            GamesClientImpl.this.a(new DisconnectedFromRoomCallback(this.Xx, dataHolder));
        }

        @Override
        public void e(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerConnectedCallback(this.Xx, dataHolder, stringArray));
        }

        @Override
        public void f(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDisconnectedCallback(this.Xx, dataHolder, stringArray));
        }

        @Override
        public void a(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerInvitedToRoomCallback(this.Xx, dataHolder, stringArray));
        }

        @Override
        public void b(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerJoinedRoomCallback(this.Xx, dataHolder, stringArray));
        }

        @Override
        public void c(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerLeftRoomCallback(this.Xx, dataHolder, stringArray));
        }

        @Override
        public void d(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDeclinedCallback(this.Xx, dataHolder, stringArray));
        }

        @Override
        public void onP2PConnected(String participantId) {
            GamesClientImpl.this.a(new P2PConnectedCallback(this.Xx, participantId));
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            GamesClientImpl.this.a(new P2PDisconnectedCallback(this.Xx, participantId));
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            GamesClientImpl.this.a(new MessageReceivedCallback(this.Xy, message));
        }
    }

    private final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> XD;

        public TurnBasedMatchCanceledBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.XD = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void h(int n2, String string) {
            Status status = new Status(n2);
            this.XD.b(new CancelMatchResultImpl(status, string));
        }
    }

    private final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> XF;

        public TurnBasedMatchLeftBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.XF = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void s(DataHolder dataHolder) {
            this.XF.b(new LeaveMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> XH;

        public TurnBasedMatchUpdatedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.XH = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void r(DataHolder dataHolder) {
            this.XH.b(new UpdateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> XE;

        public TurnBasedMatchInitiatedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.XE = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void q(DataHolder dataHolder) {
            this.XE.b(new InitiateMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> XG;

        public TurnBasedMatchLoadedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.XG = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            this.XG.b(new LoadMatchResultImpl(dataHolder));
        }
    }

    private final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> XI;

        public TurnBasedMatchesLoadedBinderCallbacks(BaseImplementation.b<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.XI = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void b(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.XI.b(new LoadMatchesResultImpl(status, bundle));
        }
    }

    private final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.SubmitScoreResult> De;

        public SubmitScoreBinderCallbacks(BaseImplementation.b<Leaderboards.SubmitScoreResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(DataHolder dataHolder) {
            this.De.b(new SubmitScoreResultImpl(dataHolder));
        }
    }

    private final class OwnerCoverPhotoUrisLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> De;

        OwnerCoverPhotoUrisLoadedBinderCallback(BaseImplementation.b<Players.LoadOwnerCoverPhotoUrisResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void d(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            this.De.b(new LoadOwnerCoverPhotoUrisResultImpl(n2, bundle));
        }
    }

    private final class ProfileSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Status> De;

        ProfileSettingsUpdatedBinderCallback(BaseImplementation.b<Status> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void dz(int n2) {
            this.De.b(new Status(n2));
        }
    }

    final class ProfileSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadProfileSettingsResult> De;

        ProfileSettingsLoadedBinderCallback(BaseImplementation.b<Players.LoadProfileSettingsResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void Q(DataHolder dataHolder) {
            this.De.b(new LoadProfileSettingsResultImpl(dataHolder));
        }
    }

    final class PlayerXpStreamLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadXpStreamResult> De;

        PlayerXpStreamLoadedBinderCallback(BaseImplementation.b<Players.LoadXpStreamResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void P(DataHolder dataHolder) {
            this.De.b(new LoadXpStreamResultImpl(dataHolder));
        }
    }

    private final class PlayerXpForGameCategoriesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadXpForGameCategoriesResult> De;

        PlayerXpForGameCategoriesLoadedBinderCallback(BaseImplementation.b<Players.LoadXpForGameCategoriesResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            this.De.b(new LoadXpForGameCategoriesResultImpl(status, bundle));
        }
    }

    private final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Players.LoadPlayersResult> De;

        PlayersLoadedBinderCallback(BaseImplementation.b<Players.LoadPlayersResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            this.De.b(new LoadPlayersResultImpl(dataHolder));
        }

        @Override
        public void h(DataHolder dataHolder) {
            this.De.b(new LoadPlayersResultImpl(dataHolder));
        }
    }

    private final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnRequestReceivedListener Xp;

        RequestReceivedBinderCallback(OnRequestReceivedListener listener) {
            this.Xp = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void o(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.release();
            }
            if (gameRequest != null) {
                GamesClientImpl.this.a(new RequestReceivedCallback(this.Xp, gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            GamesClientImpl.this.a(new RequestRemovedCallback(this.Xp, requestId));
        }
    }

    private final class QuestUpdateBinderCallback
    extends AbstractGamesCallbacks {
        private final QuestUpdateListener Xk;

        QuestUpdateBinderCallback(QuestUpdateListener listener) {
            this.Xk = listener;
        }

        @Override
        public void M(DataHolder dataHolder) {
            Quest quest = this.S(dataHolder);
            if (quest != null) {
                GamesClientImpl.this.a(new QuestCompletedCallback(this.Xk, quest));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Quest S(DataHolder dataHolder) {
            QuestBuffer questBuffer = new QuestBuffer(dataHolder);
            Quest quest = null;
            try {
                if (questBuffer.getCount() > 0) {
                    quest = (Quest)((Quest)questBuffer.get(0)).freeze();
                }
            }
            finally {
                questBuffer.release();
            }
            return quest;
        }
    }

    private final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnTurnBasedMatchUpdateReceivedListener WX;

        MatchUpdateReceivedBinderCallback(OnTurnBasedMatchUpdateReceivedListener listener) {
            this.WX = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void t(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.release();
            }
            if (turnBasedMatch != null) {
                GamesClientImpl.this.a(new MatchUpdateReceivedCallback(this.WX, turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            GamesClientImpl.this.a(new MatchRemovedCallback(this.WX, matchId));
        }
    }

    private final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnInvitationReceivedListener WB;

        InvitationReceivedBinderCallback(OnInvitationReceivedListener listener) {
            this.WB = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void n(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.release();
            }
            if (invitation != null) {
                GamesClientImpl.this.a(new InvitationReceivedCallback(this.WB, invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            GamesClientImpl.this.a(new InvitationRemovedCallback(this.WB, invitationId));
        }
    }

    private final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Invitations.LoadInvitationsResult> De;

        InvitationsLoadedBinderCallback(BaseImplementation.b<Invitations.LoadInvitationsResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void m(DataHolder dataHolder) {
            this.De.b(new LoadInvitationsResultImpl(dataHolder));
        }
    }

    private final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> De;

        PlayerLeaderboardScoreLoadedBinderCallback(BaseImplementation.b<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void E(DataHolder dataHolder) {
            this.De.b(new LoadPlayerScoreResultImpl(dataHolder));
        }
    }

    private final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LoadScoresResult> De;

        LeaderboardScoresLoadedBinderCallback(BaseImplementation.b<Leaderboards.LoadScoresResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            this.De.b(new LoadScoresResultImpl(dataHolder, dataHolder2));
        }
    }

    private final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> De;

        LeaderboardsLoadedBinderCallback(BaseImplementation.b<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            this.De.b(new LeaderboardMetadataResultImpl(dataHolder));
        }
    }

    private final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> De;

        GameSearchSuggestionsLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void l(DataHolder dataHolder) {
            this.De.b(new LoadGameSearchSuggestionsResultImpl(dataHolder));
        }
    }

    private final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> De;

        GameInstancesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGameInstancesResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            this.De.b(new LoadGameInstancesResultImpl(dataHolder));
        }
    }

    private final class ExtendedGamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> De;

        ExtendedGamesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadExtendedGamesResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void j(DataHolder dataHolder) {
            this.De.b(new LoadExtendedGamesResultImpl(dataHolder));
        }
    }

    private final class EventsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Events.LoadEventsResult> De;

        EventsLoadedBinderCallback(BaseImplementation.b<Events.LoadEventsResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            this.De.b(new LoadEventResultImpl(dataHolder));
        }
    }

    private final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<GamesMetadata.LoadGamesResult> De;

        GamesLoadedBinderCallback(BaseImplementation.b<GamesMetadata.LoadGamesResult> holder) {
            this.De = n.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void i(DataHolder dataHolder) {
            this.De.b(new LoadGamesResultImpl(dataHolder));
        }
    }

    private final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Achievements.UpdateAchievementResult> De;

        AchievementUpdatedBinderCallback(BaseImplementation.b<Achievements.UpdateAchievementResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void g(int n2, String string) {
            this.De.b(new UpdateAchievementResultImpl(n2, string));
        }
    }

    private final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final BaseImplementation.b<Achievements.LoadAchievementsResult> De;

        AchievementsLoadedBinderCallback(BaseImplementation.b<Achievements.LoadAchievementsResult> resultHolder) {
            this.De = n.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            this.De.b(new LoadAchievementsResultImpl(dataHolder));
        }
    }

    private class GameClientEventIncrementCache
    extends EventIncrementCache {
        public GameClientEventIncrementCache() {
            super(GamesClientImpl.this.getContext().getMainLooper(), 1000);
        }

        @Override
        protected void q(String string, int n2) {
            try {
                if (GamesClientImpl.this.isConnected()) {
                    ((IGamesService)GamesClientImpl.this.gS()).n(string, n2);
                } else {
                    GamesLog.q("GamesClientImpl", "Unable to increment event " + string + " by " + n2 + " because the games client is no longer connected");
                }
            }
            catch (RemoteException remoteException) {
                GamesLog.p("GamesClientImpl", "service died");
            }
        }
    }
}

