/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.jv;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int BR;
    private final String Wb;
    private final String mName;
    private final String Tg;
    private final Uri UW;
    private final String Vh;
    private final PlayerEntity VW;
    private final long Wc;
    private final String Wd;
    private final boolean We;

    public EventEntity(Event event) {
        this.BR = 1;
        this.Wb = event.getEventId();
        this.mName = event.getName();
        this.Tg = event.getDescription();
        this.UW = event.getIconImageUri();
        this.Vh = event.getIconImageUrl();
        this.VW = (PlayerEntity)event.getPlayer().freeze();
        this.Wc = event.getValue();
        this.Wd = event.getFormattedValue();
        this.We = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.BR = versionCode;
        this.Wb = eventId;
        this.mName = name;
        this.Tg = description;
        this.UW = iconImageUri;
        this.Vh = iconImageUrl;
        this.VW = new PlayerEntity(player);
        this.Wc = value;
        this.Wd = formattedValue;
        this.We = isVisible;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getEventId() {
        return this.Wb;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        jv.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Tg;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tg, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.UW;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vh;
    }

    @Override
    public Player getPlayer() {
        return this.VW;
    }

    @Override
    public long getValue() {
        return this.Wc;
    }

    @Override
    public String getFormattedValue() {
        return this.Wd;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        jv.b(this.Wd, dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.We;
    }

    @Override
    public Event freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.a(this);
    }

    static int a(Event event) {
        return m.hashCode(event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible());
    }

    public boolean equals(Object obj) {
        return EventEntity.a(this, obj);
    }

    static boolean a(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return m.equal(event2.getEventId(), event.getEventId()) && m.equal(event2.getName(), event.getName()) && m.equal(event2.getDescription(), event.getDescription()) && m.equal(event2.getIconImageUri(), event.getIconImageUri()) && m.equal(event2.getIconImageUrl(), event.getIconImageUrl()) && m.equal(event2.getPlayer(), event.getPlayer()) && m.equal(event2.getValue(), event.getValue()) && m.equal(event2.getFormattedValue(), event.getFormattedValue()) && m.equal(event2.isVisible(), event.isVisible());
    }

    public String toString() {
        return EventEntity.b(this);
    }

    static String b(Event event) {
        return m.h(event).a("Id", event.getEventId()).a("Name", event.getName()).a("Description", event.getDescription()).a("IconImageUri", event.getIconImageUri()).a("IconImageUrl", event.getIconImageUrl()).a("Player", event.getPlayer()).a("Value", event.getValue()).a("FormattedValue", event.getFormattedValue()).a("isVisible", event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.a(this, out, flags);
    }
}

