/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.a;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.jv;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final AchievementEntityCreator CREATOR = new AchievementEntityCreator();
    private final int BR;
    private final String VP;
    private final int FD;
    private final String mName;
    private final String Tg;
    private final Uri VQ;
    private final String VR;
    private final Uri VS;
    private final String VT;
    private final int VU;
    private final String VV;
    private final PlayerEntity VW;
    private final int mState;
    private final int VX;
    private final String VY;
    private final long VZ;
    private final long Wa;

    public AchievementEntity(Achievement achievement) {
        this.BR = 1;
        this.VP = achievement.getAchievementId();
        this.FD = achievement.getType();
        this.mName = achievement.getName();
        this.Tg = achievement.getDescription();
        this.VQ = achievement.getUnlockedImageUri();
        this.VR = achievement.getUnlockedImageUrl();
        this.VS = achievement.getRevealedImageUri();
        this.VT = achievement.getRevealedImageUrl();
        this.VW = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.VZ = achievement.getLastUpdatedTimestamp();
        this.Wa = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.VU = achievement.getTotalSteps();
            this.VV = achievement.getFormattedTotalSteps();
            this.VX = achievement.getCurrentSteps();
            this.VY = achievement.getFormattedCurrentSteps();
        } else {
            this.VU = 0;
            this.VV = null;
            this.VX = 0;
            this.VY = null;
        }
        a.f(this.VP);
        a.f(this.Tg);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.BR = versionCode;
        this.VP = achievementId;
        this.FD = type;
        this.mName = name;
        this.Tg = description;
        this.VQ = unlockedImageUri;
        this.VR = unlockedImageUrl;
        this.VS = revealedImageUri;
        this.VT = revealedImageUrl;
        this.VU = totalSteps;
        this.VV = formattedTotalSteps;
        this.VW = player;
        this.mState = state;
        this.VX = currentSteps;
        this.VY = formattedCurrentSteps;
        this.VZ = lastUpdatedTimestamp;
        this.Wa = xpValue;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getAchievementId() {
        return this.VP;
    }

    @Override
    public int getType() {
        return this.FD;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        jv.b(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.Tg;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tg, dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.VQ;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.VR;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.VS;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.VT;
    }

    @Override
    public int getTotalSteps() {
        return this.VU;
    }

    @Override
    public String getFormattedTotalSteps() {
        return this.VV;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        jv.b(this.VV, dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.VW;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        return this.VX;
    }

    @Override
    public String getFormattedCurrentSteps() {
        return this.VY;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        jv.b(this.VY, dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.VZ;
    }

    @Override
    public long getXpValue() {
        return this.Wa;
    }

    @Override
    public Achievement freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.a(this);
    }

    static int a(Achievement achievement) {
        int n2 = 0;
        int n3 = 0;
        if (achievement.getType() == 1) {
            n2 = achievement.getCurrentSteps();
            n3 = achievement.getTotalSteps();
        }
        return m.hashCode(achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n2, n3);
    }

    public boolean equals(Object obj) {
        return AchievementEntity.a(this, obj);
    }

    static boolean a(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl2 = true;
        boolean bl3 = true;
        if (achievement.getType() == 1) {
            bl2 = m.equal(achievement2.getCurrentSteps(), achievement.getCurrentSteps());
            bl3 = m.equal(achievement2.getTotalSteps(), achievement.getTotalSteps());
        }
        return m.equal(achievement2.getAchievementId(), achievement.getAchievementId()) && m.equal(achievement2.getName(), achievement.getName()) && m.equal(achievement2.getType(), achievement.getType()) && m.equal(achievement2.getDescription(), achievement.getDescription()) && m.equal(achievement2.getXpValue(), achievement.getXpValue()) && m.equal(achievement2.getState(), achievement.getState()) && m.equal(achievement2.getLastUpdatedTimestamp(), achievement.getLastUpdatedTimestamp()) && m.equal(achievement2.getPlayer(), achievement.getPlayer()) && bl2 && bl3;
    }

    public String toString() {
        return AchievementEntity.b(this);
    }

    static String b(Achievement achievement) {
        m.a a2 = m.h(achievement).a("Id", achievement.getAchievementId()).a("Type", achievement.getType()).a("Name", achievement.getName()).a("Description", achievement.getDescription()).a("Player", achievement.getPlayer()).a("State", achievement.getState());
        if (achievement.getType() == 1) {
            a2.a("CurrentSteps", achievement.getCurrentSteps());
            a2.a("TotalSteps", achievement.getTotalSteps());
        }
        return a2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.a(this, dest, flags);
    }
}

