/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.d;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends d
implements Player {
    private final PlayerColumnNames VN;
    private final PlayerLevelInfo VE;
    private final MostRecentGameInfoRef VO;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.VN = new PlayerColumnNames(prefix);
        this.VO = new MostRecentGameInfoRef(holder, dataRow, this.VN);
        if (this.jT()) {
            PlayerLevel playerLevel;
            int n2 = this.getInteger(this.VN.aaR);
            int n3 = this.getInteger(this.VN.aaU);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n2, this.getLong(this.VN.aaS), this.getLong(this.VN.aaT));
            if (n2 != n3) {
                playerLevel2 = new PlayerLevel(n3, this.getLong(this.VN.aaT), this.getLong(this.VN.aaV));
            }
            this.VE = new PlayerLevelInfo(this.getLong(this.VN.aaQ), this.getLong(this.VN.aaW), playerLevel, playerLevel2);
        } else {
            this.VE = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.VN.aaH);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.VN.aaI);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.a(this.VN.aaI, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.aR(this.VN.aaJ);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.VN.aaK);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.aR(this.VN.aaL);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.VN.aaM);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.VN.aaN);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.aQ(this.VN.aaP) || this.aS(this.VN.aaP)) {
            return -1L;
        }
        return this.getLong(this.VN.aaP);
    }

    @Override
    public int jR() {
        return this.getInteger(this.VN.aaO);
    }

    @Override
    public boolean isProfileVisible() {
        return this.getBoolean(this.VN.aaZ);
    }

    @Override
    public String getTitle() {
        return this.getString(this.VN.aaX);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.a(this.VN.aaX, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.VE;
    }

    @Override
    public MostRecentGameInfo jS() {
        if (this.aS(this.VN.aba)) {
            return null;
        }
        return this.VO;
    }

    @Override
    public Player freeze() {
        return new PlayerEntity(this);
    }

    @Override
    public int hashCode() {
        return PlayerEntity.b(this);
    }

    @Override
    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    public String toString() {
        return PlayerEntity.c(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean jT() {
        if (this.aS(this.VN.aaQ)) {
            return false;
        }
        return this.getLong(this.VN.aaQ) != -1L;
    }
}

