/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final PlayerLevelInfoCreator CREATOR = new PlayerLevelInfoCreator();
    private final int BR;
    private final long VJ;
    private final long VK;
    private final PlayerLevel VL;
    private final PlayerLevel VM;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        n.I(currentXpTotal != -1L);
        n.i(currentLevel);
        n.i(nextLevel);
        this.BR = versionCode;
        this.VJ = currentXpTotal;
        this.VK = lastLevelUpTimestamp;
        this.VL = currentLevel;
        this.VM = nextLevel;
    }

    public int getVersionCode() {
        return this.BR;
    }

    public long getCurrentXpTotal() {
        return this.VJ;
    }

    public long getLastLevelUpTimestamp() {
        return this.VK;
    }

    public PlayerLevel getCurrentLevel() {
        return this.VL;
    }

    public PlayerLevel getNextLevel() {
        return this.VM;
    }

    public boolean isMaxLevel() {
        return this.VL.equals(this.VM);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return m.equal(this.VJ, playerLevelInfo.VJ) && m.equal(this.VK, playerLevelInfo.VK) && m.equal(this.VL, playerLevelInfo.VL) && m.equal(this.VM, playerLevelInfo.VM);
    }

    public int hashCode() {
        return m.hashCode(this.VJ, this.VK, this.VL, this.VM);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.a(this, out, flags);
    }
}

