/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final PlayerLevelCreator CREATOR = new PlayerLevelCreator();
    private final int BR;
    private final int VG;
    private final long VH;
    private final long VI;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        n.a(minXp >= 0L, "Min XP must be positive!");
        n.a(maxXp > minXp, "Max XP must be more than min XP!");
        this.BR = versionCode;
        this.VG = levelNumber;
        this.VH = minXp;
        this.VI = maxXp;
    }

    public int getVersionCode() {
        return this.BR;
    }

    public int getLevelNumber() {
        return this.VG;
    }

    public long getMinXp() {
        return this.VH;
    }

    public long getMaxXp() {
        return this.VI;
    }

    public int hashCode() {
        return m.hashCode(this.VG, this.VH, this.VI);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return m.equal(playerLevel.getLevelNumber(), this.getLevelNumber()) && m.equal(playerLevel.getMinXp(), this.getMinXp()) && m.equal(playerLevel.getMaxXp(), this.getMaxXp());
    }

    public String toString() {
        return m.h(this).a("LevelNumber", this.getLevelNumber()).a("MinXp", this.getMinXp()).a("MaxXp", this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.a(this, out, flags);
    }
}

