/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.a;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.jv;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int BR;
    private final String Vz;
    private final String Nz;
    private final Uri UW;
    private final Uri UX;
    private final long VA;
    private final int VB;
    private final long VC;
    private final String Vh;
    private final String Vi;
    private final String No;
    private final MostRecentGameInfoEntity VD;
    private final PlayerLevelInfo VE;
    private final boolean VF;

    public PlayerEntity(Player player) {
        this.BR = 11;
        this.Vz = player.getPlayerId();
        this.Nz = player.getDisplayName();
        this.UW = player.getIconImageUri();
        this.Vh = player.getIconImageUrl();
        this.UX = player.getHiResImageUri();
        this.Vi = player.getHiResImageUrl();
        this.VA = player.getRetrievedTimestamp();
        this.VB = player.jR();
        this.VC = player.getLastPlayedWithTimestamp();
        this.No = player.getTitle();
        this.VF = player.isProfileVisible();
        MostRecentGameInfo mostRecentGameInfo = player.jS();
        this.VD = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.VE = player.getLevelInfo();
        a.f(this.Vz);
        a.f(this.Nz);
        a.I(this.VA > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible) {
        this.BR = versionCode;
        this.Vz = playerId;
        this.Nz = displayName;
        this.UW = iconImageUri;
        this.Vh = iconImageUrl;
        this.UX = hiResImageUri;
        this.Vi = hiResImageUrl;
        this.VA = retrievedTimestamp;
        this.VB = isInCircles;
        this.VC = lastPlayedWithTimestamp;
        this.No = title;
        this.VF = isProfileVisible;
        this.VD = mostRecentGameInfo;
        this.VE = playerLevelInfo;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getPlayerId() {
        return this.Vz;
    }

    @Override
    public String getDisplayName() {
        return this.Nz;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        jv.b(this.Nz, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.UW;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vh;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.UX;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Vi;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.VA;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.VC;
    }

    @Override
    public int jR() {
        return this.VB;
    }

    @Override
    public boolean isProfileVisible() {
        return this.VF;
    }

    @Override
    public String getTitle() {
        return this.No;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        jv.b(this.No, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.VE;
    }

    @Override
    public MostRecentGameInfo jS() {
        return this.VD;
    }

    @Override
    public Player freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.b(this);
    }

    static int b(Player player) {
        return m.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return m.equal(player2.getPlayerId(), player.getPlayerId()) && m.equal(player2.getDisplayName(), player.getDisplayName()) && m.equal(player2.getIconImageUri(), player.getIconImageUri()) && m.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && m.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp()) && m.equal(player2.getTitle(), player.getTitle()) && m.equal(player2.getLevelInfo(), player.getLevelInfo());
    }

    public String toString() {
        return PlayerEntity.c(this);
    }

    static String c(Player player) {
        return m.h(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("IconImageUrl", player.getIconImageUrl()).a("HiResImageUri", player.getHiResImageUri()).a("HiResImageUrl", player.getHiResImageUrl()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).a("Title", player.getTitle()).a("LevelInfo", player.getLevelInfo()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Vz);
            dest.writeString(this.Nz);
            dest.writeString(this.UW == null ? null : this.UW.toString());
            dest.writeString(this.UX == null ? null : this.UX.toString());
            dest.writeLong(this.VA);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity ce(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.gP());
            if (bl2 || PlayerEntity.aV(PlayerEntity.class.getCanonicalName())) {
                return super.ce(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l2 = parcel.readLong();
            int n2 = -1;
            long l3 = -1L;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl3 = true;
            return new PlayerEntity(11, string, string2, uri, uri2, l2, n2, l3, string5, string6, string7, mostRecentGameInfoEntity, playerLevelInfo, bl3);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.ce(x0);
        }
    }
}

