/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.jv;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int BR;
    private final String Ez;
    private final String Nz;
    private final String UT;
    private final String UU;
    private final String Tg;
    private final String UV;
    private final Uri UW;
    private final Uri UX;
    private final Uri UY;
    private final boolean UZ;
    private final boolean Va;
    private final String Vb;
    private final int Vc;
    private final int Vd;
    private final int Ve;
    private final boolean Vf;
    private final boolean Vg;
    private final String Vh;
    private final String Vi;
    private final String Vj;
    private final boolean Vk;
    private final boolean Vl;
    private final boolean Vm;
    private final String Vn;

    public GameEntity(Game game) {
        this.BR = 5;
        this.Ez = game.getApplicationId();
        this.UT = game.getPrimaryCategory();
        this.UU = game.getSecondaryCategory();
        this.Tg = game.getDescription();
        this.UV = game.getDeveloperName();
        this.Nz = game.getDisplayName();
        this.UW = game.getIconImageUri();
        this.Vh = game.getIconImageUrl();
        this.UX = game.getHiResImageUri();
        this.Vi = game.getHiResImageUrl();
        this.UY = game.getFeaturedImageUri();
        this.Vj = game.getFeaturedImageUrl();
        this.UZ = game.jL();
        this.Va = game.jN();
        this.Vb = game.jO();
        this.Vc = game.jP();
        this.Vd = game.getAchievementTotalCount();
        this.Ve = game.getLeaderboardCount();
        this.Vf = game.isRealTimeMultiplayerEnabled();
        this.Vg = game.isTurnBasedMultiplayerEnabled();
        this.Vk = game.isMuted();
        this.Vl = game.jM();
        this.Vm = game.areSnapshotsEnabled();
        this.Vn = game.getThemeColor();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor) {
        this.BR = versionCode;
        this.Ez = applicationId;
        this.Nz = displayName;
        this.UT = primaryCategory;
        this.UU = secondaryCategory;
        this.Tg = description;
        this.UV = developerName;
        this.UW = iconImageUri;
        this.Vh = iconImageUrl;
        this.UX = hiResImageUri;
        this.Vi = hiResImageUrl;
        this.UY = featuredImageUri;
        this.Vj = featuredImageUrl;
        this.UZ = playEnabledGame;
        this.Va = instanceInstalled;
        this.Vb = instancePackageName;
        this.Vc = gameplayAclStatus;
        this.Vd = achievementTotalCount;
        this.Ve = leaderboardCount;
        this.Vf = realTimeEnabled;
        this.Vg = turnBasedEnabled;
        this.Vk = muted;
        this.Vl = identitySharingConfirmed;
        this.Vm = snapshotsEnabled;
        this.Vn = themeColor;
    }

    public int getVersionCode() {
        return this.BR;
    }

    @Override
    public String getApplicationId() {
        return this.Ez;
    }

    @Override
    public String getDisplayName() {
        return this.Nz;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        jv.b(this.Nz, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.UT;
    }

    @Override
    public String getSecondaryCategory() {
        return this.UU;
    }

    @Override
    public String getDescription() {
        return this.Tg;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        jv.b(this.Tg, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.UV;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        jv.b(this.UV, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.UW;
    }

    @Override
    public String getIconImageUrl() {
        return this.Vh;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.UX;
    }

    @Override
    public String getHiResImageUrl() {
        return this.Vi;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.UY;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.Vj;
    }

    @Override
    public boolean isMuted() {
        return this.Vk;
    }

    @Override
    public boolean jM() {
        return this.Vl;
    }

    @Override
    public boolean jL() {
        return this.UZ;
    }

    @Override
    public boolean jN() {
        return this.Va;
    }

    @Override
    public String jO() {
        return this.Vb;
    }

    @Override
    public int jP() {
        return this.Vc;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.Vd;
    }

    @Override
    public int getLeaderboardCount() {
        return this.Ve;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.Vf;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.Vg;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.Vm;
    }

    @Override
    public String getThemeColor() {
        return this.Vn;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return m.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.jL(), game.jN(), game.jO(), game.jP(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.jM(), game.areSnapshotsEnabled(), game.getThemeColor());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return m.equal(game2.getApplicationId(), game.getApplicationId()) && m.equal(game2.getDisplayName(), game.getDisplayName()) && m.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && m.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && m.equal(game2.getDescription(), game.getDescription()) && m.equal(game2.getDeveloperName(), game.getDeveloperName()) && m.equal(game2.getIconImageUri(), game.getIconImageUri()) && m.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && m.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && m.equal(game2.jL(), game.jL()) && m.equal(game2.jN(), game.jN()) && m.equal(game2.jO(), game.jO()) && m.equal(game2.jP(), game.jP()) && m.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && m.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && m.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && m.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && m.equal(game2.isMuted(), game.isMuted()) && m.equal(game2.jM(), game.jM())) && m.equal(game2.areSnapshotsEnabled(), game.areSnapshotsEnabled()) && m.equal(game2.getThemeColor(), game.getThemeColor());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return m.h(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("IconImageUrl", game.getIconImageUrl()).a("HiResImageUri", game.getHiResImageUri()).a("HiResImageUrl", game.getHiResImageUrl()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("FeaturedImageUrl", game.getFeaturedImageUrl()).a("PlayEnabledGame", game.jL()).a("InstanceInstalled", game.jN()).a("InstancePackageName", game.jO()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).a("AreSnapshotsEnabled", game.areSnapshotsEnabled()).a("ThemeColor", game.getThemeColor()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.gQ()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Ez);
            dest.writeString(this.Nz);
            dest.writeString(this.UT);
            dest.writeString(this.UU);
            dest.writeString(this.Tg);
            dest.writeString(this.UV);
            dest.writeString(this.UW == null ? null : this.UW.toString());
            dest.writeString(this.UX == null ? null : this.UX.toString());
            dest.writeString(this.UY == null ? null : this.UY.toString());
            dest.writeInt(this.UZ ? 1 : 0);
            dest.writeInt(this.Va ? 1 : 0);
            dest.writeString(this.Vb);
            dest.writeInt(this.Vc);
            dest.writeInt(this.Vd);
            dest.writeInt(this.Ve);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity cd(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.gP());
            if (bl2 || GameEntity.aV(GameEntity.class.getCanonicalName())) {
                return super.cd(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            String string14 = null;
            return new GameEntity(5, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl3, bl4, string10, n2, n3, n4, bl5, bl6, string11, string12, string13, bl7, bl8, bl9, string14);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.cd(x0);
        }
    }
}

