/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.b;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int BR;
    private final List<DataSet> Sw;
    private final Status CM;
    private final List<Bucket> UK;
    private int UL;
    private final List<DataSource> SH;
    private final List<DataType> UM;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new b();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.BR = versionCode;
        this.CM = status;
        this.UL = batchCount;
        this.SH = uniqueDataSources;
        this.UM = uniqueDataTypes;
        this.Sw = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet safeParcelable : dataSets) {
            this.Sw.add(new DataSet(safeParcelable, uniqueDataSources, uniqueDataTypes));
        }
        this.UK = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.UK.add(new Bucket(rawBucket, uniqueDataSources, uniqueDataTypes));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.BR = 5;
        this.Sw = dataSets;
        this.CM = status;
        this.UK = buckets;
        this.UL = 1;
        this.SH = new ArrayList<DataSource>();
        this.UM = new ArrayList<DataType>();
    }

    public static DataReadResult a(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource safeParcelable : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(safeParcelable));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.Sw) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.Sw) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.Sw;
    }

    public List<Bucket> getBuckets() {
        return this.UK;
    }

    public int jF() {
        return this.UL;
    }

    public void b(DataReadResult dataReadResult) {
        for (DataSet safeParcelable : dataReadResult.getDataSets()) {
            this.a(safeParcelable, this.Sw);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.a(bucket, this.UK);
        }
    }

    private void a(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.a(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void a(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.b(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.a(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.UK.add(bucket);
    }

    @Override
    public Status getStatus() {
        return this.CM;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.c((DataReadResult)that);
    }

    private boolean c(DataReadResult dataReadResult) {
        return this.CM.equals(dataReadResult.CM) && m.equal(this.Sw, dataReadResult.Sw) && m.equal(this.UK, dataReadResult.UK);
    }

    public int hashCode() {
        return m.hashCode(this.CM, this.Sw, this.UK);
    }

    public String toString() {
        return m.h(this).a("status", this.CM).a("dataSets", this.Sw.size() > 5 ? this.Sw.size() + " data sets" : this.Sw).a("buckets", this.UK.size() > 5 ? this.UK.size() + " buckets" : this.UK).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    List<RawBucket> jG() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.UK.size());
        for (Bucket bucket : this.UK) {
            arrayList.add(new RawBucket(bucket, this.SH, this.UM));
        }
        return arrayList;
    }

    List<RawDataSet> jH() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.Sw.size());
        for (DataSet dataSet : this.Sw) {
            arrayList.add(new RawDataSet(dataSet, this.SH, this.UM));
        }
        return arrayList;
    }

    List<DataSource> iG() {
        return this.SH;
    }

    List<DataType> jI() {
        return this.UM;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        b.a(this, dest, flags);
    }
}

