/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.s;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionReadRequest
implements SafeParcelable {
    private final int BR;
    private final String UC;
    private final String vL;
    private final long KL;
    private final long Si;
    private final List<DataType> Su;
    private final List<DataSource> TZ;
    private boolean UD;
    private final boolean Uk;
    private final List<String> UE;
    public static final Parcelable.Creator<SessionReadRequest> CREATOR = new s();

    SessionReadRequest(int versionCode, String sessionName, String sessionId, long startTimeMillis, long endTimeMillis, List<DataType> dataTypes, List<DataSource> dataSources, boolean getSessionsFromAllApps, boolean serverQueriesEnabled, List<String> excludedPackages) {
        this.BR = versionCode;
        this.UC = sessionName;
        this.vL = sessionId;
        this.KL = startTimeMillis;
        this.Si = endTimeMillis;
        this.Su = Collections.unmodifiableList(dataTypes);
        this.TZ = Collections.unmodifiableList(dataSources);
        this.UD = getSessionsFromAllApps;
        this.Uk = serverQueriesEnabled;
        this.UE = excludedPackages;
    }

    private SessionReadRequest(Builder builder) {
        this.BR = 3;
        this.UC = builder.UC;
        this.vL = builder.vL;
        this.KL = builder.KL;
        this.Si = builder.Si;
        this.Su = Collections.unmodifiableList(builder.Su);
        this.TZ = Collections.unmodifiableList(builder.TZ);
        this.UD = builder.UD;
        this.Uk = builder.Uk;
        this.UE = builder.UE;
    }

    public String ju() {
        return this.UC;
    }

    public String getSessionId() {
        return this.vL;
    }

    public long getStartTimeMillis() {
        return this.KL;
    }

    public long getEndTimeMillis() {
        return this.Si;
    }

    public List<DataType> getDataTypes() {
        return this.Su;
    }

    public List<DataSource> getDataSources() {
        return this.TZ;
    }

    public boolean jv() {
        return this.UD;
    }

    public List<String> jw() {
        return this.UE;
    }

    public boolean jg() {
        return this.Uk;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof SessionReadRequest && this.a((SessionReadRequest)o2);
    }

    private boolean a(SessionReadRequest sessionReadRequest) {
        return m.equal(this.UC, sessionReadRequest.UC) && this.vL.equals(sessionReadRequest.vL) && this.KL == sessionReadRequest.KL && this.Si == sessionReadRequest.Si && m.equal(this.Su, sessionReadRequest.Su) && m.equal(this.TZ, sessionReadRequest.TZ) && this.UD == sessionReadRequest.UD && this.UE.equals(sessionReadRequest.UE) && this.Uk == sessionReadRequest.Uk;
    }

    public int hashCode() {
        return m.hashCode(this.UC, this.vL, this.KL, this.Si);
    }

    public String toString() {
        return m.h(this).a("sessionName", this.UC).a("sessionId", this.vL).a("startTimeMillis", this.KL).a("endTimeMillis", this.Si).a("dataTypes", this.Su).a("dataSources", this.TZ).a("sessionsFromAllApps", this.UD).a("excludedPackages", this.UE).a("useServer", this.Uk).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        s.a(this, dest, flags);
    }

    public static class Builder {
        private String UC;
        private String vL;
        private long KL = 0L;
        private long Si = 0L;
        private List<DataType> Su = new ArrayList<DataType>();
        private List<DataSource> TZ = new ArrayList<DataSource>();
        private boolean UD = false;
        private boolean Uk = false;
        private List<String> UE = new ArrayList<String>();

        public Builder setTimeInterval(long startTimeMillis, long endTimeMillis) {
            this.KL = startTimeMillis;
            this.Si = endTimeMillis;
            return this;
        }

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            return this.setTimeInterval(timeUnit.toMillis(startTime), timeUnit.toMillis(endTime));
        }

        public Builder setSessionName(String sessionName) {
            this.UC = sessionName;
            return this;
        }

        public Builder setSessionId(String sessionId) {
            this.vL = sessionId;
            return this;
        }

        public Builder read(DataSource dataSource) {
            n.b(dataSource, (Object)"Attempting to add a null data source");
            if (!this.TZ.contains(dataSource)) {
                this.TZ.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            n.b(dataType, (Object)"Attempting to use a null data type");
            if (!this.Su.contains(dataType)) {
                this.Su.add(dataType);
            }
            return this;
        }

        public Builder readSessionsFromAllApps() {
            this.UD = true;
            return this;
        }

        public Builder excludePackage(String appPackageName) {
            n.b(appPackageName, (Object)"Attempting to use a null package name");
            if (!this.UE.contains(appPackageName)) {
                this.UE.add(appPackageName);
            }
            return this;
        }

        public Builder enableServerQueries() {
            this.Uk = true;
            return this;
        }

        public SessionReadRequest build() {
            n.b(this.KL > 0L, "Invalid start time: %s", this.KL);
            n.b(this.Si > 0L && this.Si > this.KL, "Invalid end time: %s", this.Si);
            return new SessionReadRequest(this);
        }
    }
}

