/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.r;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SessionInsertRequest
implements SafeParcelable {
    private final int BR;
    private final Session Sk;
    private final List<DataSet> Sw;
    private final List<DataPoint> UA;
    public static final Parcelable.Creator<SessionInsertRequest> CREATOR = new r();

    SessionInsertRequest(int versionCode, Session session, List<DataSet> dataSets, List<DataPoint> aggregateDataPoints) {
        this.BR = versionCode;
        this.Sk = session;
        this.Sw = Collections.unmodifiableList(dataSets);
        this.UA = Collections.unmodifiableList(aggregateDataPoints);
    }

    private SessionInsertRequest(Builder builder) {
        this.BR = 1;
        this.Sk = builder.Sk;
        this.Sw = Collections.unmodifiableList(builder.Sw);
        this.UA = Collections.unmodifiableList(builder.UA);
    }

    public Session getSession() {
        return this.Sk;
    }

    public List<DataSet> getDataSets() {
        return this.Sw;
    }

    public List<DataPoint> js() {
        return this.UA;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof SessionInsertRequest && this.a((SessionInsertRequest)o2);
    }

    private boolean a(SessionInsertRequest sessionInsertRequest) {
        return m.equal(this.Sk, sessionInsertRequest.Sk) && m.equal(this.Sw, sessionInsertRequest.Sw) && m.equal(this.UA, sessionInsertRequest.UA);
    }

    public int hashCode() {
        return m.hashCode(this.Sk, this.Sw, this.UA);
    }

    public String toString() {
        return m.h(this).a("session", this.Sk).a("dataSets", this.Sw).a("aggregateDataPoints", this.UA).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        r.a(this, dest, flags);
    }

    public static class Builder {
        private Session Sk;
        private List<DataSet> Sw = new ArrayList<DataSet>();
        private List<DataPoint> UA = new ArrayList<DataPoint>();
        private List<DataSource> UB = new ArrayList<DataSource>();

        public Builder setSession(Session session) {
            this.Sk = session;
            return this;
        }

        public Builder addDataSet(DataSet dataSet) {
            n.b(dataSet != null, (Object)"Must specify a valid data set.");
            DataSource dataSource = dataSet.getDataSource();
            n.a(!this.UB.contains(dataSource), "Data set for this data source %s is already added.", dataSource);
            List<DataPoint> list = dataSet.getDataPoints();
            n.b(!list.isEmpty(), (Object)"No data points specified in the input data set.");
            this.UB.add(dataSource);
            this.Sw.add(dataSet);
            return this;
        }

        public Builder addAggregateDataPoint(DataPoint aggregateDataPoint) {
            n.b(aggregateDataPoint != null, (Object)"Must specify a valid aggregate data point.");
            long l2 = aggregateDataPoint.getStartTimeNanos();
            long l3 = aggregateDataPoint.getEndTimeNanos();
            n.b(l2 > 0L && l3 > l2, "Aggregate data point should have valid start and end times: %s", aggregateDataPoint);
            DataSource dataSource = aggregateDataPoint.getDataSource();
            n.a(!this.UB.contains(dataSource), "Data set/Aggregate data point for this data source %s is already added.", dataSource);
            this.UB.add(dataSource);
            this.UA.add(aggregateDataPoint);
            return this;
        }

        public SessionInsertRequest build() {
            n.a(this.Sk != null, "Must specify a valid session.");
            n.a(this.Sk.getEndTimeMillis() != 0L, "Must specify a valid end time, cannot insert a continuing session.");
            this.jt();
            return new SessionInsertRequest(this);
        }

        private void c(DataPoint dataPoint) {
            long l2 = TimeUnit.MILLISECONDS.toNanos(this.Sk.getStartTimeMillis());
            long l3 = TimeUnit.MILLISECONDS.toNanos(this.Sk.getEndTimeMillis());
            long l4 = dataPoint.getTimestampNanos();
            if (l4 != 0L) {
                n.a(l4 >= l2 && l4 <= l3, "Data point %s has time stamp outside session interval [%d, %d]", dataPoint, l2, l3);
            }
            long l5 = dataPoint.getStartTimeNanos();
            long l6 = dataPoint.getEndTimeNanos();
            if (l5 != 0L && l6 != 0L) {
                n.a(l5 >= l2 && l6 <= l3, "Data point %s has start and end times outside session interval [%d, %d]", dataPoint, l2, l3);
            }
        }

        private void jt() {
            for (DataSet safeParcelable : this.Sw) {
                for (DataPoint dataPoint : safeParcelable.getDataPoints()) {
                    this.c(dataPoint);
                }
            }
            for (DataPoint dataPoint : this.UA) {
                this.c(dataPoint);
            }
        }
    }
}

