/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource Sh;
    private final DataType SF;
    private final long Ti;
    private final long Ut;
    private final long Us;
    private final int Tj;
    private final LocationRequest Ux;
    private final long Uy;

    private SensorRequest(Builder builder) {
        this.Sh = builder.Sh;
        this.SF = builder.SF;
        this.Ti = builder.Ti;
        this.Ut = builder.Ut;
        this.Us = builder.Us;
        this.Tj = builder.Tj;
        this.Ux = null;
        this.Uy = builder.Uy;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.Ux = locationRequest;
        this.Ti = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.Ut = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.Us = this.Ti;
        this.SF = dataSource.getDataType();
        this.Tj = SensorRequest.a(locationRequest);
        this.Sh = dataSource;
        long l2 = locationRequest.getExpirationTime();
        this.Uy = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l2 - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int a(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.Sh;
    }

    public DataType getDataType() {
        return this.SF;
    }

    public long getSamplingRateMicros() {
        return this.Ti;
    }

    public long jm() {
        return this.Ut;
    }

    public long jn() {
        return this.Us;
    }

    public int iQ() {
        return this.Tj;
    }

    public long jr() {
        return this.Uy;
    }

    public String toString() {
        return m.h(this).a("dataSource", this.Sh).a("dataType", this.SF).a("samplingRateMicros", this.Ti).a("deliveryLatencyMicros", this.Us).a("timeOutMicros", this.Uy).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.a((SensorRequest)that);
    }

    private boolean a(SensorRequest sensorRequest) {
        return m.equal(this.Sh, sensorRequest.Sh) && m.equal(this.SF, sensorRequest.SF) && this.Ti == sensorRequest.Ti && this.Ut == sensorRequest.Ut && this.Us == sensorRequest.Us && this.Tj == sensorRequest.Tj && m.equal(this.Ux, sensorRequest.Ux) && this.Uy == sensorRequest.Uy;
    }

    public int hashCode() {
        return m.hashCode(this.Sh, this.SF, this.Ti, this.Ut, this.Us, this.Tj, this.Ux, this.Uy);
    }

    public static int da(int n2) {
        switch (n2) {
            case 1: 
            case 3: {
                return n2;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource Sh;
        private DataType SF;
        private long Ti = -1L;
        private long Ut = 0L;
        private long Us = 0L;
        private boolean Uz = false;
        private int Tj = 2;
        private long Uy = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.Sh = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.SF = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            n.b(interval >= 0L, (Object)"Cannot use a negative sampling interval");
            this.Ti = unit.toMicros(interval);
            if (!this.Uz) {
                this.Ut = this.Ti / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            n.b(fastestInterval >= 0, (Object)"Cannot use a negative interval");
            this.Uz = true;
            this.Ut = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            n.b(interval >= 0, (Object)"Cannot use a negative delivery interval");
            this.Us = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.Tj = SensorRequest.da(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            n.b(timeout > 0L, "Invalid time out value specified: %d", timeout);
            n.b(timeUnit != null, (Object)"Invalid time unit specified");
            this.Uy = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            n.a(this.Sh != null || this.SF != null, "Must call setDataSource() or setDataType()");
            n.a(this.SF == null || this.Sh == null || this.SF.equals(this.Sh.getDataType()), "Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

