/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.request.h;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataTypeCreateRequest
implements SafeParcelable {
    private final int BR;
    private final String mName;
    private final List<Field> SN;
    public static final Parcelable.Creator<DataTypeCreateRequest> CREATOR = new h();

    DataTypeCreateRequest(int versionCode, String name, List<Field> fields) {
        this.BR = versionCode;
        this.mName = name;
        this.SN = Collections.unmodifiableList(fields);
    }

    private DataTypeCreateRequest(Builder builder) {
        this.BR = 1;
        this.mName = builder.mName;
        this.SN = Collections.unmodifiableList(builder.SN);
    }

    public String getName() {
        return this.mName;
    }

    public List<Field> getFields() {
        return this.SN;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataTypeCreateRequest && this.a((DataTypeCreateRequest)o2);
    }

    private boolean a(DataTypeCreateRequest dataTypeCreateRequest) {
        return m.equal(this.mName, dataTypeCreateRequest.mName) && m.equal(this.SN, dataTypeCreateRequest.SN);
    }

    public int hashCode() {
        return m.hashCode(this.mName, this.SN);
    }

    public String toString() {
        return m.h(this).a("name", this.mName).a("fields", this.SN).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        h.a(this, dest, flags);
    }

    public static class Builder {
        private String mName;
        private List<Field> SN = new ArrayList<Field>();

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder addField(Field field) {
            if (!this.SN.contains(field)) {
                this.SN.add(field);
            }
            return this;
        }

        public Builder addField(String name, int format) {
            n.b(name != null || !name.isEmpty(), (Object)"Invalid name specified");
            Field field = new Field(name, format);
            return this.addField(field);
        }

        public DataTypeCreateRequest build() {
            n.a(this.mName != null, "Must set the name");
            n.a(!this.SN.isEmpty(), "Must specify the data fields");
            return new DataTypeCreateRequest(this);
        }
    }
}

