/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.AggregateDataTypes;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.DataTypes;
import com.google.android.gms.fitness.request.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataReadRequest
implements SafeParcelable {
    private final int BR;
    private final List<DataType> Su;
    private final List<DataSource> TZ;
    private final long KL;
    private final long Si;
    private final List<DataType> Ud;
    private final List<DataSource> Ue;
    private final int Sx;
    private final long Uf;
    private final DataSource Ug;
    private final int Uh;
    private final boolean Ui;
    private final boolean Uj;
    private final boolean Uk;
    public static final Parcelable.Creator<DataReadRequest> CREATOR = new f();

    DataReadRequest(int versionCode, List<DataType> dataTypes, List<DataSource> dataSources, long startTimeMillis, long endTimeMillis, List<DataType> aggregatedDataTypes, List<DataSource> aggregatedDataSources, int bucketType, long bucketDurationMillis, DataSource activityDataSource, int limit, boolean disableTransformations, boolean flushBeforeRead, boolean serverQueriesEnabled) {
        this.BR = versionCode;
        this.Su = Collections.unmodifiableList(dataTypes);
        this.TZ = Collections.unmodifiableList(dataSources);
        this.KL = startTimeMillis;
        this.Si = endTimeMillis;
        this.Ud = Collections.unmodifiableList(aggregatedDataTypes);
        this.Ue = Collections.unmodifiableList(aggregatedDataSources);
        this.Sx = bucketType;
        this.Uf = bucketDurationMillis;
        this.Ug = activityDataSource;
        this.Uh = limit;
        this.Ui = disableTransformations;
        this.Uj = flushBeforeRead;
        this.Uk = serverQueriesEnabled;
    }

    private DataReadRequest(Builder builder) {
        this.BR = 2;
        this.Su = Collections.unmodifiableList(builder.Su);
        this.TZ = Collections.unmodifiableList(builder.TZ);
        this.KL = builder.KL;
        this.Si = builder.Si;
        this.Ud = Collections.unmodifiableList(builder.Ud);
        this.Ue = Collections.unmodifiableList(builder.Ue);
        this.Sx = builder.Sx;
        this.Uf = builder.Uf;
        this.Ug = builder.Ug;
        this.Uh = builder.Uh;
        this.Ui = builder.Ui;
        this.Uj = builder.Uj;
        this.Uk = builder.Uk;
    }

    public List<DataType> getDataTypes() {
        return this.Su;
    }

    public List<DataSource> getDataSources() {
        return this.TZ;
    }

    public long getStartTimeMillis() {
        return this.KL;
    }

    public long getEndTimeMillis() {
        return this.Si;
    }

    public List<DataType> ja() {
        return this.Ud;
    }

    public List<DataSource> jb() {
        return this.Ue;
    }

    public int getBucketType() {
        return this.Sx;
    }

    public long jc() {
        return this.Uf;
    }

    public DataSource jd() {
        return this.Ug;
    }

    public int je() {
        return this.Uh;
    }

    public boolean jf() {
        return this.Ui;
    }

    public boolean jg() {
        return this.Uk;
    }

    public boolean jh() {
        return this.Uj;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadRequest && this.a((DataReadRequest)that);
    }

    private boolean a(DataReadRequest dataReadRequest) {
        return this.Su.equals(dataReadRequest.Su) && this.TZ.equals(dataReadRequest.TZ) && this.KL == dataReadRequest.KL && this.Si == dataReadRequest.Si && this.Sx == dataReadRequest.Sx && this.Ue.equals(dataReadRequest.Ue) && this.Ud.equals(dataReadRequest.Ud) && m.equal(this.Ug, dataReadRequest.Ug) && this.Uf == dataReadRequest.Uf && this.Uk == dataReadRequest.Uk;
    }

    public int hashCode() {
        return m.hashCode(this.Sx, this.KL, this.Si);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReadDataRequest{");
        if (!this.Su.isEmpty()) {
            for (DataType safeParcelable : this.Su) {
                stringBuilder.append(safeParcelable.iL()).append(" ");
            }
        }
        if (!this.TZ.isEmpty()) {
            for (DataSource dataSource : this.TZ) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        if (this.Sx != 0) {
            stringBuilder.append("bucket by ").append(Bucket.cz(this.Sx));
            if (this.Uf > 0L) {
                stringBuilder.append(" >").append(this.Uf).append("ms");
            }
            stringBuilder.append(": ");
        }
        if (!this.Ud.isEmpty()) {
            for (DataType dataType : this.Ud) {
                stringBuilder.append(dataType.iL()).append(" ");
            }
        }
        if (!this.Ue.isEmpty()) {
            for (DataSource dataSource : this.Ue) {
                stringBuilder.append(dataSource.toDebugString()).append(" ");
            }
        }
        stringBuilder.append(String.format("(%tF %tT - %tF %tT)", this.KL, this.KL, this.Si, this.Si));
        if (this.Ug != null) {
            stringBuilder.append("activities: ").append(this.Ug.toDebugString());
        }
        if (this.Uk) {
            stringBuilder.append(" +server");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        f.a(this, dest, flags);
    }

    public static class Builder {
        private List<DataType> Su = new ArrayList<DataType>();
        private List<DataSource> TZ = new ArrayList<DataSource>();
        private List<DataType> Ud = new ArrayList<DataType>();
        private List<DataSource> Ue = new ArrayList<DataSource>();
        private DataSource Ug;
        private long KL;
        private long Si;
        private int Sx = 0;
        private long Uf = 0L;
        private int Uh = 0;
        private boolean Ui = false;
        private boolean Uj = false;
        private boolean Uk = false;

        public Builder read(DataSource dataSource) {
            n.b(dataSource, (Object)"Attempting to add a null data source");
            n.b(!this.Ue.contains(dataSource), (Object)"Cannot add the same data source as aggregated and detailed");
            if (!this.TZ.contains(dataSource)) {
                this.TZ.add(dataSource);
            }
            return this;
        }

        public Builder read(DataType dataType) {
            n.b(dataType, (Object)"Attempting to use a null data type");
            n.a(!this.Ud.contains(dataType), "Cannot add the same data type as aggregated and detailed");
            if (!this.Su.contains(dataType)) {
                this.Su.add(dataType);
            }
            return this;
        }

        public Builder aggregate(DataSource dataSource, DataType outputDataType) {
            n.b(dataSource, (Object)"Attempting to add a null data source");
            n.a(!this.TZ.contains(dataSource), "Cannot add the same data source for aggregated and detailed");
            DataType dataType = dataSource.getDataType();
            n.b(AggregateDataTypes.INPUT_TYPES.contains(dataType), "Unsupported input data type specified for aggregation: %s", dataType);
            n.b(AggregateDataTypes.getForInput(dataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", dataType, outputDataType);
            if (!this.Ue.contains(dataSource)) {
                this.Ue.add(dataSource);
            }
            return this;
        }

        public Builder aggregate(DataType inputDataType, DataType outputDataType) {
            n.b(inputDataType, (Object)"Attempting to use a null data type");
            n.a(!this.Su.contains(inputDataType), "Cannot add the same data type as aggregated and detailed");
            n.b(AggregateDataTypes.INPUT_TYPES.contains(inputDataType), "Unsupported input data type specified for aggregation: %s", inputDataType);
            n.b(AggregateDataTypes.getForInput(inputDataType).contains(outputDataType), "Invalid output aggregate data type specified: %s -> %s", inputDataType, outputDataType);
            if (!this.Ud.contains(inputDataType)) {
                this.Ud.add(inputDataType);
            }
            return this;
        }

        public Builder bucketByTime(int duration, TimeUnit timeUnit) {
            n.b(this.Sx == 0, "Bucketing strategy already set to %s", this.Sx);
            n.b(duration > 0, "Must specify a valid minimum duration for an activity segment: %d", duration);
            this.Sx = 1;
            this.Uf = timeUnit.toMillis(duration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit) {
            n.b(this.Sx == 0, "Bucketing strategy already set to %s", this.Sx);
            n.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.Sx = 3;
            this.Uf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivityType(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            n.b(this.Sx == 0, "Bucketing strategy already set to %s", this.Sx);
            n.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            n.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            n.b(activityDataSource.getDataType().equals(DataTypes.ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.Ug = activityDataSource;
            this.Sx = 3;
            this.Uf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit) {
            n.b(this.Sx == 0, "Bucketing strategy already set to %s", this.Sx);
            n.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.Sx = 4;
            this.Uf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketByActivitySegment(int minDuration, TimeUnit timeUnit, DataSource activityDataSource) {
            n.b(this.Sx == 0, "Bucketing strategy already set to %s", this.Sx);
            n.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            n.b(activityDataSource != null, (Object)"Invalid activity data source specified");
            n.b(activityDataSource.getDataType().equals(DataTypes.ACTIVITY_SEGMENT), "Invalid activity data source specified: %s", activityDataSource);
            this.Ug = activityDataSource;
            this.Sx = 4;
            this.Uf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder bucketBySession(int minDuration, TimeUnit timeUnit) {
            n.b(this.Sx == 0, "Bucketing strategy already set to %s", this.Sx);
            n.b(minDuration > 0, "Must specify a valid minimum duration for an activity segment: %d", minDuration);
            this.Sx = 2;
            this.Uf = timeUnit.toMillis(minDuration);
            return this;
        }

        public Builder setTimeRange(long startTimeMillis, long endTimeMillis) {
            this.KL = startTimeMillis;
            this.Si = endTimeMillis;
            return this;
        }

        public Builder enableServerQueries() {
            this.Uk = true;
            return this;
        }

        public DataReadRequest build() {
            n.a(!this.TZ.isEmpty() || !this.Su.isEmpty() || !this.Ue.isEmpty() || !this.Ud.isEmpty(), "Must add at least one data source (aggregated or detailed)");
            n.a(this.KL > 0L, "Invalid start time: %s", this.KL);
            n.a(this.Si > 0L && this.Si > this.KL, "Invalid end time: %s", this.Si);
            boolean bl2 = this.Ue.isEmpty() && this.Ud.isEmpty();
            n.a(bl2 && this.Sx == 0 || !bl2 && this.Sx != 0, "Must specify a valid bucketing strategy while requesting aggregation");
            return new DataReadRequest(this);
        }
    }
}

