/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int BR;
    private final long KL;
    private final long Si;
    private final List<DataSource> TZ;
    private final List<DataType> Su;
    private final List<Session> Ua;
    private final boolean Ub;
    private final boolean Uc;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new d();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions) {
        this.BR = versionCode;
        this.KL = startTimeMillis;
        this.Si = endTimeMillis;
        this.TZ = Collections.unmodifiableList(dataSources);
        this.Su = Collections.unmodifiableList(dataTypes);
        this.Ua = sessions;
        this.Ub = deleteAllData;
        this.Uc = deleteAllSessions;
    }

    private DataDeleteRequest(Builder builder) {
        this.BR = 1;
        this.KL = builder.KL;
        this.Si = builder.Si;
        this.TZ = Collections.unmodifiableList(builder.TZ);
        this.Su = Collections.unmodifiableList(builder.Su);
        this.Ua = Collections.unmodifiableList(builder.Ua);
        this.Ub = builder.Ub;
        this.Uc = builder.Uc;
    }

    public long getStartTimeMillis() {
        return this.KL;
    }

    public long getEndTimeMillis() {
        return this.Si;
    }

    public List<DataSource> getDataSources() {
        return this.TZ;
    }

    public List<DataType> getDataTypes() {
        return this.Su;
    }

    public List<Session> getSessions() {
        return this.Ua;
    }

    public boolean iX() {
        return this.Ub;
    }

    public boolean iY() {
        return this.Uc;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataDeleteRequest && this.a((DataDeleteRequest)o2);
    }

    private boolean a(DataDeleteRequest dataDeleteRequest) {
        return this.KL == dataDeleteRequest.KL && this.Si == dataDeleteRequest.Si && m.equal(this.TZ, dataDeleteRequest.TZ) && m.equal(this.Su, dataDeleteRequest.Su) && m.equal(this.Ua, dataDeleteRequest.Ua) && this.Ub == dataDeleteRequest.Ub && this.Uc == dataDeleteRequest.Uc;
    }

    public int hashCode() {
        return m.hashCode(this.KL, this.Si);
    }

    public String toString() {
        return m.h(this).a("startTimeMillis", this.KL).a("endTimeMillis", this.Si).a("dataSources", this.TZ).a("dateTypes", this.Su).a("sessions", this.Ua).a("deleteAllData", this.Ub).a("deleteAllSessions", this.Uc).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        d.a(this, dest, flags);
    }

    public static class Builder {
        private long KL;
        private long Si;
        private List<DataSource> TZ = new ArrayList<DataSource>();
        private List<DataType> Su = new ArrayList<DataType>();
        private List<Session> Ua = new ArrayList<Session>();
        private boolean Ub = false;
        private boolean Uc = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            n.b(startTime > 0L, "Invalid start time :%d", startTime);
            n.b(endTime > startTime, "Invalid end time :%d", endTime);
            this.KL = timeUnit.toMillis(startTime);
            this.Si = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            n.b(this.Su.isEmpty() && this.TZ.isEmpty(), "Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", this.TZ, this.Su);
            this.Ub = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            n.b(!this.Ub, (Object)"All data is already marked for deletion");
            n.b(dataSource != null, (Object)"Must specify a valid data source");
            if (!this.TZ.contains(dataSource)) {
                this.TZ.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            n.b(!this.Uc, (Object)"All sessions already marked for deletion");
            n.b(session != null, (Object)"Must specify a valid session");
            n.b(session.getEndTimeMillis() > 0L, (Object)"Must specify a session that has already ended");
            this.Ua.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            n.b(this.Ua.isEmpty(), "Specific sessions already added for deletion: %s", this.Ua);
            this.Uc = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            n.b(!this.Ub, (Object)"All data is already marked for deletion");
            n.b(dataType != null, (Object)"Must specify a valid data type");
            if (!this.Su.contains(dataType)) {
                this.Su.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            n.a(this.KL > 0L && this.Si > this.KL, "Must specify a valid time interval");
            boolean bl2 = this.Ub || !this.TZ.isEmpty() || !this.Su.isEmpty();
            boolean bl3 = this.Uc || !this.Ua.isEmpty();
            n.a(bl2 || bl3, "No data or session marked for deletion");
            this.iZ();
            return new DataDeleteRequest(this);
        }

        private void iZ() {
            if (this.Ua.isEmpty()) {
                return;
            }
            for (Session session : this.Ua) {
                n.a(session.getStartTimeMillis() >= this.KL && session.getEndTimeMillis() <= this.Si, "Session %s is outside the time interval [%d, %d]", session, this.KL, this.Si);
            }
        }
    }
}

