/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.u;

public final class Value
implements SafeParcelable {
    private final int BR;
    private final int ST;
    private boolean Tk;
    private float Tl;
    public static final Parcelable.Creator<Value> CREATOR = new u();

    Value(int format) {
        this(1, format, false, 0.0f);
    }

    Value(int versionCode, int format, boolean isSet, float value) {
        this.BR = versionCode;
        this.ST = format;
        this.Tk = isSet;
        this.Tl = value;
    }

    public void setInt(int value) {
        n.a(this.ST == 1, "Attempting to set an int value to a field that is not in INT32 format.  Please check the data type definition and use the right format.");
        this.Tk = true;
        this.Tl = Float.intBitsToFloat(value);
    }

    public void setFloat(float value) {
        n.a(this.ST == 2, "Attempting to set an float value to a field that is not in FLOAT format.  Please check the data type definition and use the right format.");
        this.Tk = true;
        this.Tl = value;
    }

    public boolean isSet() {
        return this.Tk;
    }

    public int getFormat() {
        return this.ST;
    }

    public int asInt() {
        n.a(this.ST == 1, "Value is not in int format");
        return Float.floatToRawIntBits(this.Tl);
    }

    public float asFloat() {
        n.a(this.ST == 2, "Value is not in float format");
        return this.Tl;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof Value && this.a((Value)o2);
    }

    private boolean a(Value value) {
        if (this.ST == value.ST && this.Tk == value.Tk) {
            switch (this.ST) {
                case 1: {
                    return this.asInt() == value.asInt();
                }
                case 2: {
                    return this.asFloat() == value.asFloat();
                }
            }
            return this.Tl == value.Tl;
        }
        return false;
    }

    public int hashCode() {
        return m.hashCode(Float.valueOf(this.Tl), this.ST, this.Tk);
    }

    public String toString() {
        switch (this.ST) {
            case 1: {
                return Integer.toString(this.asInt());
            }
            case 2: {
                return Float.toString(this.asFloat());
            }
        }
        return "unknown";
    }

    int getVersionCode() {
        return this.BR;
    }

    float iS() {
        return this.Tl;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        u.a(this, dest, flags);
    }
}

