/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.FitnessActivities;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.p;

public class Session
implements SafeParcelable {
    private final int BR;
    private final long KL;
    private final long Si;
    private final String mName;
    private final String Tf;
    private final String Tg;
    private final int Sv;
    private final a SJ;
    public static final Parcelable.Creator<Session> CREATOR = new p();

    Session(int versionCode, long startTimeMillis, long endTimeMillis, String name, String identifier, String description, int activity, a application) {
        this.BR = versionCode;
        this.KL = startTimeMillis;
        this.Si = endTimeMillis;
        this.mName = name;
        this.Tf = identifier;
        this.Tg = description;
        this.Sv = activity;
        this.SJ = application;
    }

    private Session(Builder builder) {
        this.BR = 2;
        this.KL = builder.KL;
        this.Si = builder.Si;
        this.mName = builder.mName;
        this.Tf = builder.Tf;
        this.Tg = builder.Tg;
        this.Sv = builder.Sv;
        this.SJ = builder.SJ;
    }

    public static Session extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, "vnd.google.fitness.session", CREATOR);
    }

    public long getStartTimeMillis() {
        return this.KL;
    }

    public long getEndTimeMillis() {
        return this.Si;
    }

    public boolean isOngoing() {
        return this.Si == 0L;
    }

    public String getName() {
        return this.mName;
    }

    public String getIdentifier() {
        return this.Tf;
    }

    public String getDescription() {
        return this.Tg;
    }

    public int getActivity() {
        return this.Sv;
    }

    public a iH() {
        return this.SJ;
    }

    public String getAppPackageName() {
        return this.SJ == null ? null : this.SJ.getPackageName();
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof Session && this.a((Session)o2);
    }

    private boolean a(Session session) {
        return this.KL == session.KL && this.Si == session.Si && m.equal(this.mName, session.mName) && m.equal(this.Tf, session.Tf) && m.equal(this.Tg, session.Tg) && m.equal(this.SJ, session.SJ) && this.Sv == session.Sv;
    }

    public int hashCode() {
        return m.hashCode(this.KL, this.Si, this.mName, this.Tf, this.Sv, this.SJ, this.Tg);
    }

    public String toString() {
        return m.h(this).a("startTime", this.KL).a("endTime", this.Si).a("name", this.mName).a("identifier", this.Tf).a("description", this.Tg).a("activity", this.Sv).a("application", this.SJ).toString();
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        p.a(this, dest, flags);
    }

    public static class Builder {
        private long KL = 0L;
        private long Si = 0L;
        private String mName = null;
        private String Tf;
        private String Tg;
        private int Sv = 4;
        private a SJ;

        public Builder setStartTimeMillis(long startTimeMillis) {
            n.a(startTimeMillis > 0L, "Start time should be positive.");
            this.KL = startTimeMillis;
            return this;
        }

        public Builder setEndTimeMillis(long endTimeMillis) {
            n.a(endTimeMillis >= 0L, "End time should be positive.");
            this.Si = endTimeMillis;
            return this;
        }

        public Builder setName(String name) {
            n.b(name.length() <= 100, "Session name cannot exceed %d characters", 100);
            this.mName = name;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            this.Tf = identifier;
            return this;
        }

        public Builder setDescription(String description) {
            n.b(description.length() <= 1000, "Session description cannot exceed %d characters", 1000);
            this.Tg = description;
            return this;
        }

        public Builder setActivity(int activity) {
            this.Sv = FitnessActivities.cw(activity);
            return this;
        }

        public Session build() {
            n.a(this.KL > 0L, "Start time should be specified.");
            n.a(this.Si == 0L || this.Si > this.KL, "End time should be later than start time.");
            if (this.Tf == null) {
                this.Tf = (this.mName == null ? "" : this.mName) + this.KL;
            }
            return new Session(this);
        }
    }
}

