/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.m;
import java.util.ArrayList;
import java.util.List;

public final class RawBucket
implements SafeParcelable {
    final int BR;
    final long KL;
    final long Si;
    final Session Sk;
    final int Sv;
    final List<RawDataSet> Sw;
    final int Sx;
    final boolean Sy;
    public static final Parcelable.Creator<RawBucket> CREATOR = new m();

    RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.BR = versionCode;
        this.KL = startTimeMillis;
        this.Si = endTimeMillis;
        this.Sk = session;
        this.Sv = activity;
        this.Sw = dataSets;
        this.Sx = bucketType;
        this.Sy = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.BR = 2;
        this.KL = bucket.getStartTimeMillis();
        this.Si = bucket.getEndTimeMillis();
        this.Sk = bucket.getSession();
        this.Sv = bucket.getActivity();
        this.Sx = bucket.getBucketType();
        this.Sy = bucket.iB();
        List<DataSet> list = bucket.getDataSets();
        this.Sw = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.Sw.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof RawBucket && this.a((RawBucket)o2);
    }

    private boolean a(RawBucket rawBucket) {
        return this.KL == rawBucket.KL && this.Si == rawBucket.Si && this.Sv == rawBucket.Sv && com.google.android.gms.common.internal.m.equal(this.Sw, rawBucket.Sw) && this.Sx == rawBucket.Sx && this.Sy == rawBucket.Sy;
    }

    public int hashCode() {
        return com.google.android.gms.common.internal.m.hashCode(this.KL, this.Si, this.Sx);
    }

    public String toString() {
        return com.google.android.gms.common.internal.m.h(this).a("startTime", this.KL).a("endTime", this.Si).a("activity", this.Sv).a("dataSets", this.Sw).a("bucketType", this.Sx).a("serverHasMoreData", this.Sy).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        m.a(this, parcel, flags);
    }
}

