/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.i;
import com.google.android.gms.internal.kv;

public final class Device
implements SafeParcelable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_PHONE = 1;
    public static final int TYPE_TABLET = 2;
    public static final int TYPE_WATCH = 3;
    public static final int TYPE_CHEST_STRAP = 4;
    public static final int TYPE_SCALE = 5;
    private final int BR;
    private final String SQ;
    private final String SR;
    private final String Sq;
    private final String SS;
    private final int FD;
    public static final Parcelable.Creator<Device> CREATOR = new i();

    public static Device getLocalDevice(Context context) {
        int n2 = Device.M(context);
        return new Device(Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE, Build.SERIAL, n2);
    }

    private static int M(Context context) {
        switch (Device.O(context)) {
            case 10: {
                return Device.N(context) ? 3 : 0;
            }
            case 8: 
            case 9: {
                return 0;
            }
        }
        return Device.Q(context) ? 1 : 2;
    }

    public static boolean N(Context context) {
        Configuration configuration = context.getResources().getConfiguration();
        return (configuration.uiMode & 0xF) == 6;
    }

    private static int O(Context context) {
        return Device.P(context) % 1000 / 100 + 5;
    }

    private static int P(Context context) {
        try {
            String string2 = "com.google.android.gms";
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(string2, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"Fitness", (String)"Could not find package info for Google Play Services");
            return -1;
        }
    }

    private static boolean Q(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getPhoneType() != 0;
    }

    public Device(String manufacturer, String model, String uid, int type) {
        this(1, manufacturer, model, "", uid, type);
    }

    public Device(String manufacturer, String model, String version, String uid, int type) {
        this(manufacturer, model, uid, type);
    }

    Device(int versionCode, String manufacturer, String model, String version, String uid, int type) {
        this.BR = versionCode;
        this.SQ = n.i(manufacturer);
        this.SR = n.i(model);
        this.Sq = "";
        this.SS = n.i(uid);
        this.FD = type;
    }

    public String getManufacturer() {
        return this.SQ;
    }

    public String getModel() {
        return this.SR;
    }

    public String getVersion() {
        return this.Sq;
    }

    public String getUid() {
        return this.SS;
    }

    public int getType() {
        return this.FD;
    }

    String getStreamIdentifier() {
        return String.format("%s:%s:%s", this.SQ, this.SR, this.SS);
    }

    Device iM() {
        return new Device(kv.bq(this.SQ), kv.bq(this.SR), kv.bq(this.Sq), this.SS, this.FD);
    }

    public String iN() {
        return kv.iU() ? this.SS : kv.bq(this.SS);
    }

    public String toString() {
        return String.format("Device{%s:%s:%s}", this.getStreamIdentifier(), this.Sq, this.FD);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Device && this.a((Device)that);
    }

    private boolean a(Device device) {
        return m.equal(this.SQ, device.SQ) && m.equal(this.SR, device.SR) && m.equal(this.Sq, device.Sq) && m.equal(this.SS, device.SS) && this.FD == device.FD;
    }

    public int hashCode() {
        return m.hashCode(this.SQ, this.SR, this.Sq, this.SS, this.FD);
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        i.a(this, parcel, flags);
    }
}

