/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Device;
import com.google.android.gms.fitness.data.a;
import com.google.android.gms.fitness.data.g;
import com.google.android.gms.internal.kv;

public class DataSource
implements SafeParcelable {
    public static final int TYPE_RAW = 0;
    public static final int TYPE_DERIVED = 1;
    private final int BR;
    private final DataType SF;
    private final String mName;
    private final int FD;
    private final Device SI;
    private final a SJ;
    private final String SK;
    private final boolean SL;
    private final String SM;
    public static final Parcelable.Creator<DataSource> CREATOR = new g();

    DataSource(int versionCode, DataType dataType, String name, int type, Device device, a application, String streamName, boolean isObfuscated) {
        this.BR = versionCode;
        this.SF = dataType;
        this.FD = type;
        this.mName = name;
        this.SI = device;
        this.SJ = application;
        this.SK = streamName;
        this.SL = isObfuscated;
        this.SM = this.iI();
    }

    private DataSource(Builder builder) {
        this.BR = 3;
        this.SF = builder.SF;
        this.FD = builder.FD;
        this.mName = builder.mName;
        this.SI = builder.SI;
        this.SJ = builder.SJ;
        this.SK = builder.SK;
        this.SL = builder.SL;
        this.SM = this.iI();
    }

    public DataType getDataType() {
        return this.SF;
    }

    public int getType() {
        return this.FD;
    }

    public String getName() {
        return this.mName;
    }

    public String getAppPackageName() {
        return this.SJ == null ? null : this.SJ.getPackageName();
    }

    public a iH() {
        return this.SJ;
    }

    public Device getDevice() {
        return this.SI;
    }

    public String getStreamName() {
        return this.SK;
    }

    public String getStreamIdentifier() {
        return this.SM;
    }

    private String iI() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeString());
        stringBuilder.append(":").append(this.SF.getName());
        if (this.SJ != null) {
            stringBuilder.append(":").append(this.SJ.getPackageName());
        }
        if (this.SI != null) {
            stringBuilder.append(":").append(this.SI.getStreamIdentifier());
        }
        if (this.SK != null) {
            stringBuilder.append(":").append(this.SK);
        }
        return stringBuilder.toString();
    }

    public boolean iJ() {
        return this.SL;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataSource && this.a((DataSource)that);
    }

    private boolean a(DataSource dataSource) {
        return this.SF.equals(dataSource.SF) && this.FD == dataSource.FD && m.equal(this.mName, dataSource.mName) && m.equal(this.SI, dataSource.SI) && m.equal(this.SK, dataSource.SK) && m.equal(this.SJ, dataSource.SJ);
    }

    public int hashCode() {
        return this.SM.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("DataSource{");
        stringBuilder.append(this.getTypeString());
        if (this.mName != null) {
            stringBuilder.append(":").append(this.mName);
        }
        if (this.SJ != null) {
            stringBuilder.append(":").append(this.SJ);
        }
        if (this.SI != null) {
            stringBuilder.append(":").append(this.SI);
        }
        if (this.SK != null) {
            stringBuilder.append(":").append(this.SK);
        }
        stringBuilder.append(":").append(this.SF);
        return stringBuilder.append("}").toString();
    }

    public String toDebugString() {
        return (this.FD == 0 ? "r" : "d") + ":" + this.SF.iL() + (this.SJ == null ? "" : (this.SJ.equals(a.Sp) ? ":gms" : ":" + this.SJ.getPackageName())) + (this.SI != null ? ":" + this.SI.getModel() : "") + (this.SK != null ? ":" + this.SK : "");
    }

    private String getTypeString() {
        switch (this.FD) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "derived";
            }
        }
        throw new IllegalArgumentException("invalid type value");
    }

    public DataSource iK() {
        Device device = this.SI == null ? null : this.SI.iM();
        a a2 = this.SJ == null ? null : this.SJ.iA();
        return new DataSource(3, this.SF, this.mName, this.FD, device, a2, kv.bq(this.SK), this.SL);
    }

    int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        DataSource dataSource = kv.c(this);
        g.a(dataSource, parcel, flags);
    }

    public static final class Builder {
        private DataType SF;
        private int FD = -1;
        private String mName;
        private Device SI;
        private a SJ;
        private String SK = "";
        private boolean SL = false;

        public Builder setDataType(DataType dataType) {
            this.SF = dataType;
            return this;
        }

        public Builder setType(int type) {
            this.FD = type;
            return this;
        }

        public Builder setName(String name) {
            this.mName = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.SI = device;
            return this;
        }

        public Builder setAppPackageName(String packageName) {
            this.SJ = new a(packageName, null, null);
            return this;
        }

        public Builder setAppPackageName(Context appContext) {
            return this.setAppPackageName(appContext.getPackageName());
        }

        public Builder setStreamName(String streamName) {
            n.b(streamName != null, (Object)"Must specify a valid stream name");
            this.SK = streamName;
            return this;
        }

        public Builder setObfuscated(boolean isObfuscated) {
            this.SL = isObfuscated;
            return this;
        }

        public DataSource build() {
            n.a(this.SF != null, "Must set data type");
            n.a(this.FD >= 0, "Must set data source type");
            return new DataSource(this);
        }
    }
}

