/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int BR;
    private final DataSource Sh;
    private final DataType SF;
    private final List<DataPoint> SG;
    private final List<DataSource> SH;
    private boolean Sy = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new f();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.BR = versionCode;
        this.Sh = dataSource;
        this.SF = dataType;
        this.Sy = serverHasMoreData;
        this.SG = new ArrayList<DataPoint>(dataPoints.size());
        this.SH = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.SG.add(new DataPoint(this.SH, rawDataPoint));
        }
    }

    private DataSet(DataSource dataSource, DataType dataType) {
        this.BR = 3;
        this.Sh = n.i(dataSource);
        this.SF = n.i(dataType);
        this.SG = new ArrayList<DataPoint>();
        this.SH = new ArrayList<DataSource>();
        this.SH.add(this.Sh);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this(3, DataSet.b(uniqueDataSources, dataSet.Tb), DataSet.b(uniqueDataTypes, dataSet.Td), dataSet.Te, uniqueDataSources, dataSet.Sy);
    }

    private static <T> T b(List<T> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? (T)list.get(n2) : null;
    }

    public static DataSet create(DataSource dataSource) {
        return new DataSet(dataSource, dataSource.getDataType());
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.Sh);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        n.b(dataSource.getStreamIdentifier().equals(this.Sh.getStreamIdentifier()), "Conflicting data sources found %s vs %s", dataSource, this.Sh);
        n.b(dataPoint.getDataType().getName().equals(this.SF.getName()), "Conflicting data types found %s vs %s", dataPoint.getDataType(), this.SF);
        n.b(dataPoint.getTimestampNanos() > 0L, "Data point does not have the timestamp set: %s", dataPoint);
        n.b(dataPoint.getStartTimeNanos() <= dataPoint.getEndTimeNanos(), "Data point with start time greater than end time found: %s", dataPoint);
        this.b(dataPoint);
    }

    public void b(DataPoint dataPoint) {
        this.SG.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.SH.contains(dataSource)) {
            this.SH.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void a(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.b(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.Sh;
    }

    public DataType getDataType() {
        return this.SF;
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.SG);
    }

    public boolean iB() {
        return this.Sy;
    }

    public boolean equals(Object o2) {
        return o2 == this || o2 instanceof DataSet && this.a((DataSet)o2);
    }

    private boolean a(DataSet dataSet) {
        return m.equal(this.SF, dataSet.SF) && m.equal(this.Sh, dataSet.Sh) && m.equal(this.SG, dataSet.SG) && this.Sy == dataSet.Sy;
    }

    public int hashCode() {
        return m.hashCode(this.SF, this.Sh);
    }

    public String toString() {
        List<RawDataPoint> list = this.iF();
        return String.format("DataSet{%s %s}", this.Sh.toDebugString(), this.SG.size() < 10 ? list : String.format("%d data points, first 5: %s", this.SG.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.BR;
    }

    List<RawDataPoint> iF() {
        return this.e(this.SH);
    }

    List<RawDataPoint> e(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.SG.size());
        for (DataPoint dataPoint : this.SG) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> iG() {
        return this.SH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        f.a(this, parcel, flags);
    }
}

