/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.m;
import com.google.android.gms.common.internal.n;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.c;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.e;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int BR;
    private final DataSource Sh;
    private long Sz;
    private long SA;
    private final Value[] SB;
    private DataSource SC;
    private long SD;
    private long SE;
    public static final Parcelable.Creator<DataPoint> CREATOR = new e();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.BR = versionCode;
        this.Sh = dataSource;
        this.SC = originalDataSource;
        this.Sz = timestampNanos;
        this.SA = startTimeNanos;
        this.SB = values;
        this.SD = rawTimestamp;
        this.SE = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(4, DataPoint.a(dataSources, rawDataPoint.Tb), rawDataPoint.Sz, rawDataPoint.SA, rawDataPoint.SB, DataPoint.a(dataSources, rawDataPoint.Tc), rawDataPoint.SD, rawDataPoint.SE);
    }

    private static DataSource a(List<DataSource> list, int n2) {
        return n2 >= 0 && n2 < list.size() ? list.get(n2) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.BR = 4;
        this.Sh = n.b(dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.SB = new Value[list.size()];
        int n2 = 0;
        for (Field field : list) {
            this.SB[n2] = new Value(field.getFormat());
            ++n2;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return c.a(intent, "com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestampNanos(long timestampNanos) {
        this.Sz = timestampNanos;
        return this;
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit unit) {
        return this.setTimestampNanos(unit.toNanos(timestamp));
    }

    public DataPoint setTimeIntervalNanos(long startTimeNanos, long endTimeNanos) {
        this.SA = startTimeNanos;
        this.Sz = endTimeNanos;
        return this;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit unit) {
        return this.setTimeIntervalNanos(unit.toNanos(startTime), unit.toNanos(endTime));
    }

    public Value getValue(Field field) {
        int n2 = this.getDataType().indexOf(field);
        return this.SB[n2];
    }

    public Value[] iC() {
        return this.SB;
    }

    public DataPoint setFloatValues(float ... values) {
        this.cB(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.SB[i2].setFloat(values[i2]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.cB(values.length);
        for (int i2 = 0; i2 < values.length; ++i2) {
            this.SB[i2].setInt(values[i2]);
        }
        return this;
    }

    private void cB(int n2) {
        List<Field> list = this.getDataType().getFields();
        int n3 = list.size();
        n.b(n2 == n3, "Attempting to insert %s values, but needed %s: %s", n2, n3, list);
    }

    public DataType getDataType() {
        return this.Sh.getDataType();
    }

    public DataSource getDataSource() {
        return this.Sh;
    }

    public DataSource getOriginalDataSource() {
        return this.SC;
    }

    public long getTimestampNanos() {
        return this.Sz;
    }

    public long iD() {
        return this.SD;
    }

    public long iE() {
        return this.SE;
    }

    public long getStartTimeNanos() {
        return this.SA;
    }

    public long getEndTimeNanos() {
        return this.Sz;
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 instanceof DataPoint && this.a((DataPoint)o2);
    }

    private boolean a(DataPoint dataPoint) {
        return m.equal(this.Sh, dataPoint.Sh) && this.Sz == dataPoint.Sz && this.SA == dataPoint.SA && Arrays.equals(this.SB, dataPoint.SB) && m.equal(this.SC, dataPoint.SC);
    }

    public int hashCode() {
        return m.hashCode(this.Sh, this.Sz, this.SA);
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.SB), this.SA, this.Sz, this.SD, this.SE, this.Sh, this.SC);
    }

    public int getVersionCode() {
        return this.BR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        e.a(this, parcel, flags);
    }
}

